/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.ArrayValue;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.common.v1.KeyValueList;
import io.opentelemetry.proto.logs.v1.LogRecord;
import io.opentelemetry.proto.logs.v1.ResourceLogs;
import io.opentelemetry.proto.metrics.v1.Exemplar;
import io.opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import io.opentelemetry.proto.resource.v1.Resource;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import io.opentelemetry.proto.trace.v1.ScopeSpans;
import io.opentelemetry.proto.trace.v1.Span;
import io.opentelemetry.proto.trace.v1.Status;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.log.JacksonStandardOTelLog;
import org.opensearch.dataprepper.model.log.OpenTelemetryLog;
import org.opensearch.dataprepper.model.metric.Bucket;
import org.opensearch.dataprepper.model.metric.DefaultBucket;
import org.opensearch.dataprepper.model.metric.DefaultExemplar;
import org.opensearch.dataprepper.model.metric.DefaultQuantile;
import org.opensearch.dataprepper.model.metric.JacksonExponentialHistogram;
import org.opensearch.dataprepper.model.metric.JacksonGauge;
import org.opensearch.dataprepper.model.metric.JacksonHistogram;
import org.opensearch.dataprepper.model.metric.JacksonStandardExponentialHistogram;
import org.opensearch.dataprepper.model.metric.JacksonStandardGauge;
import org.opensearch.dataprepper.model.metric.JacksonStandardHistogram;
import org.opensearch.dataprepper.model.metric.JacksonStandardSum;
import org.opensearch.dataprepper.model.metric.JacksonStandardSummary;
import org.opensearch.dataprepper.model.metric.JacksonSum;
import org.opensearch.dataprepper.model.metric.JacksonSummary;
import org.opensearch.dataprepper.model.metric.Quantile;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.trace.DefaultLink;
import org.opensearch.dataprepper.model.trace.DefaultSpanEvent;
import org.opensearch.dataprepper.model.trace.DefaultTraceGroupFields;
import org.opensearch.dataprepper.model.trace.JacksonSpan;
import org.opensearch.dataprepper.model.trace.JacksonStandardSpan;
import org.opensearch.dataprepper.model.trace.Link;
import org.opensearch.dataprepper.model.trace.SpanEvent;
import org.opensearch.dataprepper.model.trace.TraceGroupFields;
import org.opensearch.dataprepper.plugins.otel.codec.OTelDecodingException;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTelProtoStandardCodec {
    private static final Logger LOG = LoggerFactory.getLogger(OTelProtoStandardCodec.class);
    public static final int DEFAULT_EXPONENTIAL_HISTOGRAM_MAX_ALLOWED_SCALE = 10;
    private static final double OTEL_NEGATIVE_INFINITY = -3.4028234663852886E38;
    private static final double OTEL_POSITIVE_INFINITY = 3.4028234663852886E38;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final long NANO_MULTIPLIER = 1000000000L;
    protected static final String SERVICE_NAME = "service.name";
    static final String ATTRIBUTES_KEY = "attributes";
    static final String STATUS_CODE_KEY = "code";
    static final String STATUS_MESSAGE_KEY = "message";
    static final String NAME_KEY = "name";
    static final String SCHEMA_URL_KEY = "schemaUrl";
    static final String VERSION_KEY = "version";
    static final String DROPPED_ATTRIBUTES_COUNT_KEY = "droppedAttributesCount";
    private static final Map<BoundsKey, double[]> EXPONENTIAL_BUCKET_BOUNDS = new ConcurrentHashMap<BoundsKey, double[]>();

    public static Object convertAnyValue(AnyValue value) {
        switch (value.getValueCase()) {
            case VALUE_NOT_SET: 
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case INT_VALUE: {
                return value.getIntValue();
            }
            case DOUBLE_VALUE: {
                return value.getDoubleValue();
            }
            case ARRAY_VALUE: {
                return value.getArrayValue().getValuesList().stream().map(OTelProtoStandardCodec::convertAnyValue).collect(Collectors.toList());
            }
            case KVLIST_VALUE: {
                return value.getKvlistValue().getValuesList().stream().collect(Collectors.toMap(i -> i.getKey(), i -> OTelProtoStandardCodec.convertAnyValue(i.getValue())));
            }
        }
        throw new RuntimeException(String.format("Can not convert AnyValue of type %s", value.getValueCase()));
    }

    public static Double getValueAsDouble(NumberDataPoint ndp) {
        NumberDataPoint.ValueCase ndpCase = ndp.getValueCase();
        if (NumberDataPoint.ValueCase.AS_DOUBLE == ndpCase) {
            return ndp.getAsDouble();
        }
        if (NumberDataPoint.ValueCase.AS_INT == ndpCase) {
            return ndp.getAsInt();
        }
        return null;
    }

    public static Double getExemplarValueAsDouble(Exemplar exemplar) {
        Exemplar.ValueCase valueCase = exemplar.getValueCase();
        if (Exemplar.ValueCase.AS_DOUBLE == valueCase) {
            return exemplar.getAsDouble();
        }
        if (Exemplar.ValueCase.AS_INT == valueCase) {
            return exemplar.getAsInt();
        }
        return null;
    }

    public static Map<String, Object> getInstrumentationScopeAttributes(InstrumentationScope instrumentationScope) {
        HashMap<String, Object> instrumentationScopeAttr = new HashMap<String, Object>();
        if (!instrumentationScope.getName().isEmpty()) {
            instrumentationScopeAttr.put(NAME_KEY, instrumentationScope.getName());
        }
        if (!instrumentationScope.getVersion().isEmpty()) {
            instrumentationScopeAttr.put(VERSION_KEY, instrumentationScope.getVersion());
        }
        instrumentationScopeAttr.put(DROPPED_ATTRIBUTES_COUNT_KEY, instrumentationScope.getDroppedAttributesCount());
        List attributesList = instrumentationScope.getAttributesList();
        if (!attributesList.isEmpty()) {
            instrumentationScopeAttr.put(ATTRIBUTES_KEY, OTelProtoStandardCodec.convertKeyValueToAttributes(attributesList));
        }
        return instrumentationScopeAttr;
    }

    public static String getStartTimeISO8601(NumberDataPoint numberDataPoint) {
        return OTelProtoCommonUtils.convertUnixNanosToISO8601(numberDataPoint.getStartTimeUnixNano());
    }

    public static String getTimeISO8601(NumberDataPoint ndp) {
        return OTelProtoCommonUtils.convertUnixNanosToISO8601(ndp.getTimeUnixNano());
    }

    public static Optional<String> getServiceName(Resource resource) {
        return resource.getAttributesList().stream().filter(keyValue -> keyValue.getKey().equals(SERVICE_NAME) && !keyValue.getValue().getStringValue().isEmpty()).findFirst().map(i -> i.getValue().getStringValue());
    }

    public static Map<String, Object> mergeAllAttributes(Collection<Map<String, Object>> attributes) {
        return attributes.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static List<Quantile> getQuantileValues(List<SummaryDataPoint.ValueAtQuantile> quantileValues) {
        return quantileValues.stream().map(q -> new DefaultQuantile(Double.valueOf(q.getQuantile()), Double.valueOf(q.getValue()))).collect(Collectors.toList());
    }

    public static List<Bucket> createBuckets(List<Long> bucketCountsList, List<Double> explicitBoundsList) {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        if (bucketCountsList.isEmpty()) {
            return buckets;
        }
        if (bucketCountsList.size() - 1 != explicitBoundsList.size()) {
            LOG.error("bucket count list not equals to bounds list {} {}", (Object)bucketCountsList.size(), (Object)explicitBoundsList.size());
            throw new IllegalArgumentException("OpenTelemetry protocol mandates that the number of elements in bucket_counts array must be by one greater than\n  // the number of elements in explicit_bounds array.");
        }
        if (bucketCountsList.size() == 1) {
            double min = -3.4028234663852886E38;
            double max = 3.4028234663852886E38;
            Long bucketCount = bucketCountsList.get(0);
            buckets.add((Bucket)new DefaultBucket(Double.valueOf(min), Double.valueOf(max), bucketCount));
        } else {
            for (int i = 0; i < bucketCountsList.size(); ++i) {
                Long bucketCount;
                double max;
                double min;
                if (i == 0) {
                    min = -3.4028234663852886E38;
                    max = explicitBoundsList.get(i);
                    bucketCount = bucketCountsList.get(i);
                    buckets.add((Bucket)new DefaultBucket(Double.valueOf(min), Double.valueOf(max), bucketCount));
                    continue;
                }
                if (i == bucketCountsList.size() - 1) {
                    min = explicitBoundsList.get(i - 1);
                    max = 3.4028234663852886E38;
                    bucketCount = bucketCountsList.get(i);
                    buckets.add((Bucket)new DefaultBucket(Double.valueOf(min), Double.valueOf(max), bucketCount));
                    continue;
                }
                min = explicitBoundsList.get(i - 1);
                max = explicitBoundsList.get(i);
                bucketCount = bucketCountsList.get(i);
                buckets.add((Bucket)new DefaultBucket(Double.valueOf(min), Double.valueOf(max), bucketCount));
            }
        }
        return buckets;
    }

    static Map<String, Object> convertKeyValueToAttributes(List<KeyValue> attributesList) {
        return attributesList.stream().collect(Collectors.toMap(i -> i.getKey(), i -> OTelProtoStandardCodec.convertAnyValue(i.getValue())));
    }

    public static List<org.opensearch.dataprepper.model.metric.Exemplar> convertExemplars(List<Exemplar> exemplarsList) {
        return exemplarsList.stream().map(exemplar -> new DefaultExemplar(OTelProtoCommonUtils.convertUnixNanosToISO8601(exemplar.getTimeUnixNano()), OTelProtoStandardCodec.getExemplarValueAsDouble(exemplar), OTelProtoCommonUtils.convertByteStringToString(exemplar.getSpanId()), OTelProtoCommonUtils.convertByteStringToString(exemplar.getTraceId()), OTelProtoStandardCodec.convertKeyValueToAttributes(exemplar.getFilteredAttributesList()))).collect(Collectors.toList());
    }

    static double[] calculateBoundsForScale(BoundsKey key) {
        double base = Math.pow(2.0, Math.pow(2.0, -key.getScale().intValue()));
        int maxIndex = Math.toIntExact(Math.round(Math.log(Double.MAX_VALUE) / Math.log(base)));
        double[] boundaries = new double[maxIndex + 1];
        for (int i = 0; i <= maxIndex; ++i) {
            boundaries[i] = Math.pow(base, key.getSign() == BoundsKey.Sign.POSITIVE ? (double)i : (double)(-i));
        }
        return boundaries;
    }

    public static List<Bucket> createExponentialBuckets(ExponentialHistogramDataPoint.Buckets buckets, int scale) {
        int offset = buckets.getOffset();
        BoundsKey key = new BoundsKey(scale, offset < 0 ? BoundsKey.Sign.NEGATIVE : BoundsKey.Sign.POSITIVE);
        double[] bucketBounds = EXPONENTIAL_BUCKET_BOUNDS.computeIfAbsent(key, boundsKey -> OTelProtoStandardCodec.calculateBoundsForScale(key));
        ArrayList<Bucket> mappedBuckets = new ArrayList<Bucket>();
        List bucketsList = buckets.getBucketCountsList();
        int boundOffset = Math.abs(offset);
        if (bucketsList.size() + boundOffset >= bucketBounds.length) {
            LOG.error("Max offset is out of range for Double data type, ignoring buckets");
        } else {
            for (int i = 0; i < bucketsList.size(); ++i) {
                Long value = (Long)bucketsList.get(i);
                double lowerBound = bucketBounds[boundOffset + i];
                double upperBound = bucketBounds[boundOffset + i + 1];
                mappedBuckets.add((Bucket)new DefaultBucket(Double.valueOf(lowerBound), Double.valueOf(upperBound), value));
            }
        }
        return mappedBuckets;
    }

    public static class OTelProtoEncoder
    implements OTelProtoCodec.OTelProtoEncoder {
        @Override
        public ResourceSpans convertToResourceSpans(org.opensearch.dataprepper.model.trace.Span span) throws UnsupportedEncodingException, DecoderException {
            ResourceSpans.Builder rsBuilder = ResourceSpans.newBuilder();
            Map allAttributes = span.getAttributes();
            Resource resource = this.constructResource(span.getResource());
            rsBuilder.setResource(resource);
            if (span.getResource() != null) {
                rsBuilder.setSchemaUrl((String)span.getResource().get(OTelProtoStandardCodec.SCHEMA_URL_KEY));
            }
            ScopeSpans.Builder scopeSpansBuilder = ScopeSpans.newBuilder();
            InstrumentationScope instrumentationScope = this.constructInstrumentationScope(span.getScope());
            scopeSpansBuilder.setScope(instrumentationScope);
            if (span.getSchemaUrl() != null) {
                scopeSpansBuilder.setSchemaUrl(span.getSchemaUrl());
            }
            Span otelProtoSpan = this.constructSpan(span);
            scopeSpansBuilder.addSpans(otelProtoSpan);
            rsBuilder.addScopeSpans(scopeSpansBuilder);
            return rsBuilder.build();
        }

        protected Resource constructResource(Map<String, Object> resourceAttrs) throws UnsupportedEncodingException {
            Resource.Builder rsBuilder = Resource.newBuilder();
            List<Object> resourceAttributes = List.of();
            if (resourceAttrs != null) {
                Integer droppedAttributesCount;
                Map attributes = (Map)resourceAttrs.get(OTelProtoStandardCodec.ATTRIBUTES_KEY);
                if (attributes != null) {
                    resourceAttributes = this.convertAttributesToKeyValue(attributes);
                }
                if ((droppedAttributesCount = (Integer)resourceAttrs.get(OTelProtoStandardCodec.DROPPED_ATTRIBUTES_COUNT_KEY)) != null) {
                    rsBuilder.setDroppedAttributesCount(droppedAttributesCount.intValue());
                }
            }
            rsBuilder.addAllAttributes(resourceAttributes);
            return rsBuilder.build();
        }

        protected Map<String, Object> convertKeyValueToAttributes(List<KeyValue> keyValues) {
            return keyValues.stream().collect(Collectors.toMap(i -> i.getKey(), i -> OTelProtoStandardCodec.convertAnyValue(i.getValue())));
        }

        protected List<KeyValue> convertAttributesToKeyValue(Map<String, Object> attributes) throws UnsupportedEncodingException {
            ArrayList<KeyValue> result = new ArrayList<KeyValue>();
            if (attributes != null && attributes.size() > 0) {
                for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                    KeyValue keyValue = KeyValue.newBuilder().setKey(entry.getKey()).setValue(this.objectToAnyValue(entry.getValue())).build();
                    result.add(keyValue);
                }
            }
            return result;
        }

        protected InstrumentationScope constructInstrumentationScope(Map<String, Object> scopeAttributes) throws UnsupportedEncodingException, DecoderException {
            InstrumentationScope.Builder builder = InstrumentationScope.newBuilder();
            if (scopeAttributes != null && scopeAttributes.size() > 0) {
                Map attributes;
                Integer droppedAttributesCount;
                String version;
                String name = (String)scopeAttributes.get(OTelProtoStandardCodec.NAME_KEY);
                if (name != null) {
                    builder.setName(name);
                }
                if ((version = (String)scopeAttributes.get(OTelProtoStandardCodec.VERSION_KEY)) != null) {
                    builder.setVersion(version);
                }
                if ((droppedAttributesCount = (Integer)scopeAttributes.get(OTelProtoStandardCodec.DROPPED_ATTRIBUTES_COUNT_KEY)) != null) {
                    builder.setDroppedAttributesCount(droppedAttributesCount.intValue());
                }
                if ((attributes = (Map)scopeAttributes.get(OTelProtoStandardCodec.ATTRIBUTES_KEY)) != null) {
                    builder.addAllAttributes(this.convertAttributesToKeyValue(attributes));
                }
            }
            return builder.build();
        }

        protected Status constructSpanStatus(Map<String, Object> attributes) {
            Status.Builder builder = Status.newBuilder();
            if (attributes != null && attributes.size() > 0) {
                Optional<Integer> statusCode = Optional.ofNullable((Integer)attributes.get(OTelProtoStandardCodec.STATUS_CODE_KEY));
                Optional<String> statusMessage = Optional.ofNullable((String)attributes.get(OTelProtoStandardCodec.STATUS_MESSAGE_KEY));
                statusCode.ifPresent(arg_0 -> ((Status.Builder)builder).setCodeValue(arg_0));
                statusMessage.ifPresent(arg_0 -> ((Status.Builder)builder).setMessage(arg_0));
            }
            return builder.build();
        }

        protected List<Span.Event> convertSpanEvents(List<? extends SpanEvent> spanEvents) throws UnsupportedEncodingException {
            ArrayList<Span.Event> result = new ArrayList<Span.Event>();
            for (SpanEvent spanEvent : spanEvents) {
                result.add(this.convertSpanEvent(spanEvent));
            }
            return result;
        }

        protected Span.Event convertSpanEvent(SpanEvent spanEvent) throws UnsupportedEncodingException {
            Span.Event.Builder builder = Span.Event.newBuilder();
            builder.setName(spanEvent.getName());
            builder.setTimeUnixNano(OTelProtoCommonUtils.convertISO8601ToNanos(spanEvent.getTime()));
            builder.setDroppedAttributesCount(spanEvent.getDroppedAttributesCount().intValue());
            ArrayList<KeyValue> attributeKeyValueList = new ArrayList<KeyValue>();
            for (Map.Entry entry : spanEvent.getAttributes().entrySet()) {
                KeyValue.Builder setValue = KeyValue.newBuilder().setKey((String)entry.getKey()).setValue(this.objectToAnyValue(entry.getValue()));
                attributeKeyValueList.add(setValue.build());
            }
            builder.addAllAttributes(attributeKeyValueList);
            return builder.build();
        }

        protected List<Span.Link> convertSpanLinks(List<? extends Link> links) throws DecoderException, UnsupportedEncodingException {
            ArrayList<Span.Link> result = new ArrayList<Span.Link>();
            for (Link link : links) {
                result.add(this.convertSpanLink(link));
            }
            return result;
        }

        protected Span.Link convertSpanLink(Link link) throws DecoderException, UnsupportedEncodingException {
            Span.Link.Builder builder = Span.Link.newBuilder();
            builder.setSpanId(ByteString.copyFrom((byte[])Hex.decodeHex((String)link.getSpanId())));
            builder.setTraceId(ByteString.copyFrom((byte[])Hex.decodeHex((String)link.getTraceId())));
            builder.setTraceState(link.getTraceState());
            builder.setDroppedAttributesCount(link.getDroppedAttributesCount().intValue());
            ArrayList<KeyValue> attributeKeyValueList = new ArrayList<KeyValue>();
            for (Map.Entry entry : link.getAttributes().entrySet()) {
                KeyValue.Builder setValue = KeyValue.newBuilder().setKey((String)entry.getKey()).setValue(this.objectToAnyValue(entry.getValue()));
                attributeKeyValueList.add(setValue.build());
            }
            builder.addAllAttributes(attributeKeyValueList);
            return builder.build();
        }

        protected Span constructSpan(org.opensearch.dataprepper.model.trace.Span span) throws DecoderException, UnsupportedEncodingException {
            Map allAttributes = span.getAttributes();
            Span.Builder builder = Span.newBuilder().setSpanId(ByteString.copyFrom((byte[])Hex.decodeHex((String)span.getSpanId()))).setParentSpanId(ByteString.copyFrom((byte[])Hex.decodeHex((String)span.getParentSpanId()))).setTraceId(ByteString.copyFrom((byte[])Hex.decodeHex((String)span.getTraceId()))).setTraceState(span.getTraceState()).setName(span.getName()).setKind(Span.SpanKind.valueOf((String)span.getKind())).setStartTimeUnixNano(OTelProtoCommonUtils.convertISO8601ToNanos(span.getStartTime())).setEndTimeUnixNano(OTelProtoCommonUtils.convertISO8601ToNanos(span.getEndTime())).setDroppedAttributesCount(span.getDroppedAttributesCount().intValue()).setDroppedEventsCount(span.getDroppedEventsCount().intValue()).setDroppedLinksCount(span.getDroppedLinksCount().intValue());
            builder.setStatus(this.constructSpanStatus(span.getStatus())).addAllAttributes(this.convertAttributesToKeyValue(allAttributes)).addAllEvents(this.convertSpanEvents(span.getEvents())).addAllLinks(this.convertSpanLinks(span.getLinks()));
            return builder.build();
        }

        protected AnyValue objectToAnyValue(Object obj) throws UnsupportedEncodingException {
            AnyValue.Builder anyValueBuilder = AnyValue.newBuilder();
            if (obj == null) {
                return anyValueBuilder.build();
            }
            if (obj instanceof Integer || obj instanceof Long) {
                anyValueBuilder.setIntValue(((Number)obj).longValue());
            } else if (obj instanceof String) {
                anyValueBuilder.setStringValue((String)obj);
            } else if (obj instanceof Boolean) {
                anyValueBuilder.setBoolValue(((Boolean)obj).booleanValue());
            } else if (obj instanceof Double) {
                anyValueBuilder.setDoubleValue(((Double)obj).doubleValue());
            } else if (obj instanceof List) {
                ArrayList<AnyValue> arrayValues = new ArrayList<AnyValue>();
                for (Object aobj : (List)obj) {
                    arrayValues.add(this.objectToAnyValue(aobj));
                }
                anyValueBuilder.setArrayValue(ArrayValue.newBuilder().addAllValues(arrayValues));
            } else if (obj instanceof Map) {
                Map nestedMap = (Map)obj;
                List nestedKeyValues = nestedMap.entrySet().stream().map(entry -> {
                    try {
                        return KeyValue.newBuilder().setKey((String)entry.getKey()).setValue(this.objectToAnyValue(entry.getValue())).build();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("error");
                    }
                }).collect(Collectors.toList());
                anyValueBuilder.setKvlistValue(KeyValueList.newBuilder().addAllValues(nestedKeyValues));
            } else {
                throw new UnsupportedEncodingException(String.format("Unsupported object type: %s in io.opentelemetry.proto.common.v1.AnyValue encoding", obj.getClass().toString()));
            }
            return anyValueBuilder.build();
        }
    }

    public static class OTelProtoDecoder
    implements OTelProtoCodec.OTelProtoDecoder {
        @Override
        public List<org.opensearch.dataprepper.model.trace.Span> parseExportTraceServiceRequest(ExportTraceServiceRequest exportTraceServiceRequest, Instant timeReceived) {
            return exportTraceServiceRequest.getResourceSpansList().stream().flatMap(rs -> this.parseResourceSpans((ResourceSpans)rs, timeReceived).stream()).collect(Collectors.toList());
        }

        @Override
        public Map<String, ExportTraceServiceRequest> splitExportTraceServiceRequestByTraceId(ExportTraceServiceRequest exportTraceServiceRequest) {
            HashMap<String, ExportTraceServiceRequest> result = new HashMap<String, ExportTraceServiceRequest>();
            HashMap<String, ExportTraceServiceRequest.Builder> resultBuilderMap = new HashMap<String, ExportTraceServiceRequest.Builder>();
            for (ResourceSpans resourceSpans : exportTraceServiceRequest.getResourceSpansList()) {
                for (Map.Entry<String, ResourceSpans> entry : this.splitResourceSpansByTraceId(resourceSpans).entrySet()) {
                    String traceId = entry.getKey();
                    if (resultBuilderMap.containsKey(traceId)) {
                        ((ExportTraceServiceRequest.Builder)resultBuilderMap.get(traceId)).addResourceSpans(entry.getValue());
                        continue;
                    }
                    resultBuilderMap.put(traceId, ExportTraceServiceRequest.newBuilder().addResourceSpans(entry.getValue()));
                }
            }
            for (Map.Entry entry : resultBuilderMap.entrySet()) {
                result.put((String)entry.getKey(), ((ExportTraceServiceRequest.Builder)entry.getValue()).build());
            }
            return result;
        }

        @Override
        public List<OpenTelemetryLog> parseExportLogsServiceRequest(ExportLogsServiceRequest exportLogsServiceRequest, Instant timeReceived) {
            return exportLogsServiceRequest.getResourceLogsList().stream().flatMap(rs -> this.parseResourceLogs((ResourceLogs)rs, timeReceived)).collect(Collectors.toList());
        }

        protected Stream<OpenTelemetryLog> parseResourceLogs(ResourceLogs rs, Instant timeReceived) {
            String serviceName = this.getServiceName(rs.getResource()).orElse(null);
            Map<String, Object> resourceAttributes = this.getResourceAttributes(rs.getResource(), rs.getSchemaUrl());
            Stream<OpenTelemetryLog> mappedScopeListLogs = rs.getScopeLogsList().stream().map(sls -> this.processLogsList(sls.getLogRecordsList(), serviceName, OTelProtoStandardCodec.getInstrumentationScopeAttributes(sls.getScope()), resourceAttributes, sls.getSchemaUrl(), timeReceived)).flatMap(Collection::stream);
            return mappedScopeListLogs;
        }

        protected Map<String, ResourceSpans> splitResourceSpansByTraceId(ResourceSpans resourceSpans) {
            Resource resource = resourceSpans.getResource();
            boolean hasResource = resourceSpans.hasResource();
            HashMap<String, ResourceSpans> result = new HashMap<String, ResourceSpans>();
            HashMap<String, ResourceSpans.Builder> resultBuilderMap = new HashMap<String, ResourceSpans.Builder>();
            if (!resourceSpans.getScopeSpansList().isEmpty()) {
                for (Map.Entry<Object, Object> entry : this.splitScopeSpansByTraceId(resourceSpans.getScopeSpansList()).entrySet()) {
                    ResourceSpans.Builder resourceSpansBuilder = ResourceSpans.newBuilder().addAllScopeSpans((Iterable)entry.getValue());
                    if (hasResource) {
                        resourceSpansBuilder.setResource(resource);
                    }
                    resultBuilderMap.put((String)entry.getKey(), resourceSpansBuilder);
                }
            }
            for (Map.Entry<Object, Object> entry : resultBuilderMap.entrySet()) {
                result.put((String)entry.getKey(), ((ResourceSpans.Builder)entry.getValue()).build());
            }
            return result;
        }

        protected Map<String, Object> convertKeyValueToAttributes(List<KeyValue> attributesList) {
            return attributesList.stream().collect(Collectors.toMap(i -> i.getKey(), i -> this.convertAnyValue(i.getValue())));
        }

        protected List<org.opensearch.dataprepper.model.trace.Span> parseResourceSpans(ResourceSpans resourceSpans, Instant timeReceived) {
            String serviceName = this.getServiceName(resourceSpans.getResource()).orElse(null);
            Map<String, Object> resourceAttributes = this.getResourceAttributes(resourceSpans.getResource(), resourceSpans.getSchemaUrl());
            if (!resourceSpans.getScopeSpansList().isEmpty()) {
                return this.parseScopeSpans(resourceSpans.getScopeSpansList(), serviceName, resourceAttributes, timeReceived);
            }
            LOG.debug("No spans found to parse from ResourceSpans object: {}", (Object)resourceSpans);
            return Collections.emptyList();
        }

        private List<org.opensearch.dataprepper.model.trace.Span> parseScopeSpans(List<ScopeSpans> scopeSpansList, String serviceName, Map<String, Object> resourceAttributes, Instant timeReceived) {
            return scopeSpansList.stream().map(scopeSpans -> this.parseSpans(scopeSpans.getSpansList(), scopeSpans.getScope(), scopeSpans.getSchemaUrl(), OTelProtoStandardCodec::getInstrumentationScopeAttributes, serviceName, resourceAttributes, timeReceived)).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private Map<String, List<ScopeSpans>> splitScopeSpansByTraceId(List<ScopeSpans> scopeSpansList) {
            HashMap<String, List<ScopeSpans>> result = new HashMap<String, List<ScopeSpans>>();
            for (ScopeSpans ss : scopeSpansList) {
                boolean hasScope = ss.hasScope();
                InstrumentationScope scope = ss.getScope();
                for (Map.Entry<String, List<Span>> entry : this.splitSpansByTraceId(ss.getSpansList()).entrySet()) {
                    String traceId;
                    ScopeSpans.Builder scopeSpansBuilder = ScopeSpans.newBuilder().addAllSpans((Iterable)entry.getValue());
                    if (hasScope) {
                        scopeSpansBuilder.setScope(scope);
                    }
                    if (!result.containsKey(traceId = entry.getKey())) {
                        result.put(traceId, new ArrayList());
                    }
                    ((List)result.get(traceId)).add(scopeSpansBuilder.build());
                }
            }
            return result;
        }

        private Map<String, List<Span>> splitSpansByTraceId(List<Span> spans) {
            HashMap<String, List<Span>> result = new HashMap<String, List<Span>>();
            for (Span span : spans) {
                List<Span> spanList;
                String traceId = OTelProtoCommonUtils.convertByteStringToString(span.getTraceId());
                if (result.containsKey(traceId)) {
                    spanList = (List)result.get(traceId);
                } else {
                    spanList = new ArrayList();
                    result.put(traceId, spanList);
                }
                spanList.add(span);
            }
            return result;
        }

        private <T> List<org.opensearch.dataprepper.model.trace.Span> parseSpans(List<Span> spans, T scope, String schemaUrl, Function<T, Map<String, Object>> scopeAttributesGetter, String serviceName, Map<String, Object> resourceAttributes, Instant timeReceived) {
            return spans.stream().map(span -> {
                Map scopeAttributes = (Map)scopeAttributesGetter.apply(scope);
                return this.parseSpan((Span)span, scopeAttributes, schemaUrl, serviceName, resourceAttributes, timeReceived);
            }).collect(Collectors.toList());
        }

        protected List<OpenTelemetryLog> processLogsList(List<LogRecord> logsList, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, Instant timeReceived) {
            return logsList.stream().map(log -> JacksonStandardOTelLog.builder().withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(log.getTimeUnixNano())).withObservedTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(log.getObservedTimeUnixNano())).withAttributes(this.convertKeyValueToAttributes(log.getAttributesList())).withScope(ils).withResource(resourceAttributes).withSchemaUrl(schemaUrl).withFlags(Integer.valueOf(log.getFlags())).withTraceId(OTelProtoCommonUtils.convertByteStringToString(log.getTraceId())).withSpanId(OTelProtoCommonUtils.convertByteStringToString(log.getSpanId())).withSeverityNumber(Integer.valueOf(log.getSeverityNumberValue())).withSeverityText(log.getSeverityText()).withDroppedAttributesCount(Integer.valueOf(log.getDroppedAttributesCount())).withBody(this.convertAnyValue(log.getBody())).withTimeReceived(timeReceived).build()).collect(Collectors.toList());
        }

        private Map<String, Object> getStatus(Status status) {
            return Map.of(OTelProtoStandardCodec.STATUS_MESSAGE_KEY, status.getMessage(), OTelProtoStandardCodec.STATUS_CODE_KEY, status.getCodeValue());
        }

        protected org.opensearch.dataprepper.model.trace.Span parseSpan(Span sp, Map<String, Object> instrumentationScopeAttributes, String schemaUrl, String serviceName, Map<String, Object> resourceAttributes, Instant timeReceived) {
            JacksonSpan span = JacksonStandardSpan.builder().withSpanId(OTelProtoCommonUtils.convertByteStringToString(sp.getSpanId())).withTraceId(OTelProtoCommonUtils.convertByteStringToString(sp.getTraceId())).withTraceState(sp.getTraceState()).withParentSpanId(OTelProtoCommonUtils.convertByteStringToString(sp.getParentSpanId())).withName(sp.getName()).withSchemaUrl(schemaUrl).withKind(sp.getKind().name()).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(sp.getStartTimeUnixNano())).withEndTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(sp.getEndTimeUnixNano())).withStatus(this.getStatus(sp.getStatus())).withFlags(Integer.valueOf(sp.getFlags())).withScope(instrumentationScopeAttributes).withResource(resourceAttributes).withAttributes(this.convertKeyValueToAttributes(sp.getAttributesList())).withDroppedAttributesCount(Integer.valueOf(sp.getDroppedAttributesCount())).withEvents(sp.getEventsList().stream().map(this::getSpanEvent).collect(Collectors.toList())).withDroppedEventsCount(Integer.valueOf(sp.getDroppedEventsCount())).withLinks(sp.getLinksList().stream().map(this::getLink).collect(Collectors.toList())).withDroppedLinksCount(Integer.valueOf(sp.getDroppedLinksCount())).withDurationInNanos(Long.valueOf(sp.getEndTimeUnixNano() - sp.getStartTimeUnixNano())).withTimeReceived(timeReceived).build();
            EventMetadata eventMetadata = span.getMetadata();
            eventMetadata.setAttribute("serviceName", (Object)serviceName);
            eventMetadata.setAttribute("traceGroup", (Object)this.getTraceGroup(sp));
            eventMetadata.setAttribute("traceGroupFields", (Object)this.getTraceGroupFields(sp));
            return span;
        }

        protected Object convertAnyValue(AnyValue value) {
            switch (value.getValueCase()) {
                case VALUE_NOT_SET: 
                case STRING_VALUE: {
                    return value.getStringValue();
                }
                case BOOL_VALUE: {
                    return value.getBoolValue();
                }
                case INT_VALUE: {
                    return value.getIntValue();
                }
                case DOUBLE_VALUE: {
                    return value.getDoubleValue();
                }
                case ARRAY_VALUE: {
                    return value.getArrayValue().getValuesList().stream().map(OTelProtoStandardCodec::convertAnyValue).collect(Collectors.toList());
                }
                case KVLIST_VALUE: {
                    return value.getKvlistValue().getValuesList().stream().collect(Collectors.toMap(i -> i.getKey(), i -> this.convertAnyValue(i.getValue())));
                }
            }
            throw new OTelDecodingException("Unknown case");
        }

        protected SpanEvent getSpanEvent(Span.Event event) {
            return DefaultSpanEvent.builder().withTime(this.getTimeISO8601(event)).withName(event.getName()).withAttributes(this.convertKeyValueToAttributes(event.getAttributesList())).withDroppedAttributesCount(Integer.valueOf(event.getDroppedAttributesCount())).build();
        }

        protected Link getLink(Span.Link link) {
            return DefaultLink.builder().withSpanId(OTelProtoCommonUtils.convertByteStringToString(link.getSpanId())).withTraceId(OTelProtoCommonUtils.convertByteStringToString(link.getTraceId())).withTraceState(link.getTraceState()).withDroppedAttributesCount(Integer.valueOf(link.getDroppedAttributesCount())).withAttributes(this.convertKeyValueToAttributes(link.getAttributesList())).build();
        }

        protected Map<String, Object> getSpanAttributes(Span span) {
            return span.getAttributesList().stream().collect(Collectors.toMap(i -> i.getKey(), i -> this.convertAnyValue(i.getValue())));
        }

        protected Map<String, Object> getResourceAttributes(Resource resource, String schemaUrl) {
            Map<String, Object> attributes = resource.getAttributesList().stream().collect(Collectors.toMap(i -> i.getKey(), i -> this.convertAnyValue(i.getValue())));
            return Map.of(OTelProtoStandardCodec.ATTRIBUTES_KEY, attributes, OTelProtoStandardCodec.DROPPED_ATTRIBUTES_COUNT_KEY, resource.getDroppedAttributesCount(), OTelProtoStandardCodec.SCHEMA_URL_KEY, schemaUrl);
        }

        protected String getTraceGroup(Span span) {
            return span.getParentSpanId().isEmpty() ? span.getName() : null;
        }

        protected TraceGroupFields getTraceGroupFields(Span span) {
            DefaultTraceGroupFields.Builder traceGroupFieldsBuilder = DefaultTraceGroupFields.builder();
            if (span.getParentSpanId().isEmpty()) {
                traceGroupFieldsBuilder = traceGroupFieldsBuilder.withDurationInNanos(Long.valueOf(span.getEndTimeUnixNano() - span.getStartTimeUnixNano())).withEndTime(this.getEndTimeISO8601(span)).withStatusCode(Integer.valueOf(span.getStatus().getCodeValue()));
            }
            return traceGroupFieldsBuilder.build();
        }

        protected Map<String, Object> getSpanStatusAttributes(Status status) {
            HashMap<String, Object> statusAttr = new HashMap<String, Object>();
            statusAttr.put(OTelProtoStandardCodec.STATUS_CODE_KEY, status.getCodeValue());
            if (!status.getMessage().isEmpty()) {
                statusAttr.put(OTelProtoStandardCodec.STATUS_MESSAGE_KEY, status.getMessage());
            }
            return statusAttr;
        }

        protected String getStartTimeISO8601(Span span) {
            return OTelProtoCommonUtils.convertUnixNanosToISO8601(span.getStartTimeUnixNano());
        }

        protected String getEndTimeISO8601(Span span) {
            return OTelProtoCommonUtils.convertUnixNanosToISO8601(span.getEndTimeUnixNano());
        }

        protected String getTimeISO8601(Span.Event event) {
            return OTelProtoCommonUtils.convertUnixNanosToISO8601(event.getTimeUnixNano());
        }

        protected Optional<String> getServiceName(Resource resource) {
            return resource.getAttributesList().stream().filter(keyValue -> keyValue.getKey().equals(OTelProtoStandardCodec.SERVICE_NAME) && !keyValue.getValue().getStringValue().isEmpty()).findFirst().map(i -> i.getValue().getStringValue());
        }

        @Override
        public Collection<Record<? extends org.opensearch.dataprepper.model.metric.Metric>> parseExportMetricsServiceRequest(ExportMetricsServiceRequest request, AtomicInteger droppedCounter, Integer exponentialHistogramMaxAllowedScale, Instant timeReceived, boolean calculateHistogramBuckets, boolean calculateExponentialHistogramBuckets, boolean flattenAttributes) {
            ArrayList<Record<? extends org.opensearch.dataprepper.model.metric.Metric>> recordsOut = new ArrayList<Record<? extends org.opensearch.dataprepper.model.metric.Metric>>();
            for (ResourceMetrics rs : request.getResourceMetricsList()) {
                Map<String, Object> resourceAttributes = this.getResourceAttributes(rs.getResource(), rs.getSchemaUrl());
                String serviceName = this.getServiceName(rs.getResource()).orElse(null);
                for (ScopeMetrics sm : rs.getScopeMetricsList()) {
                    String schemaUrl = sm.getSchemaUrl();
                    Map<String, Object> ils = OTelProtoStandardCodec.getInstrumentationScopeAttributes(sm.getScope());
                    recordsOut.addAll(this.processMetricsList(sm.getMetricsList(), serviceName, ils, resourceAttributes, schemaUrl, droppedCounter, exponentialHistogramMaxAllowedScale, timeReceived, calculateHistogramBuckets, calculateExponentialHistogramBuckets));
                }
            }
            return recordsOut;
        }

        private List<? extends Record<? extends org.opensearch.dataprepper.model.metric.Metric>> processMetricsList(List<Metric> metricsList, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, AtomicInteger droppedCounter, Integer exponentialHistogramMaxAllowedScale, Instant timeReceived, boolean calculateHistogramBuckets, boolean calculateExponentialHistogramBuckets) {
            ArrayList<Object> recordsOut = new ArrayList<Object>();
            for (Metric metric : metricsList) {
                try {
                    if (metric.hasGauge()) {
                        recordsOut.addAll(this.mapGauge(metric, serviceName, ils, resourceAttributes, schemaUrl, timeReceived));
                        continue;
                    }
                    if (metric.hasSum()) {
                        recordsOut.addAll(this.mapSum(metric, serviceName, ils, resourceAttributes, schemaUrl, timeReceived));
                        continue;
                    }
                    if (metric.hasSummary()) {
                        recordsOut.addAll(this.mapSummary(metric, serviceName, ils, resourceAttributes, schemaUrl, timeReceived));
                        continue;
                    }
                    if (metric.hasHistogram()) {
                        recordsOut.addAll(this.mapHistogram(metric, serviceName, ils, resourceAttributes, schemaUrl, timeReceived, calculateHistogramBuckets));
                        continue;
                    }
                    if (!metric.hasExponentialHistogram()) continue;
                    recordsOut.addAll(this.mapExponentialHistogram(metric, serviceName, ils, resourceAttributes, schemaUrl, exponentialHistogramMaxAllowedScale, timeReceived, calculateExponentialHistogramBuckets));
                }
                catch (Exception e) {
                    LOG.warn("Error while processing metrics", (Throwable)e);
                    droppedCounter.incrementAndGet();
                }
            }
            return recordsOut;
        }

        private Map<String, Object> getMetricMetadata(Metric metric) {
            List metadata = metric.getMetadataList();
            return this.convertKeyValueToAttributes(metadata);
        }

        private List<? extends Record<? extends org.opensearch.dataprepper.model.metric.Metric>> mapGauge(Metric metric, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, Instant timeReceived) {
            return metric.getGauge().getDataPointsList().stream().map(dp -> ((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)((JacksonGauge.Builder)JacksonStandardGauge.builder().withUnit(metric.getUnit())).withName(metric.getName())).withDescription(metric.getDescription())).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getStartTimeUnixNano()))).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getTimeUnixNano()))).withValue(OTelProtoStandardCodec.getValueAsDouble(dp)).withScope(ils)).withMetricMetadata(this.getMetricMetadata(metric))).withResource(resourceAttributes)).withAttributes(this.convertKeyValueToAttributes(dp.getAttributesList()))).withSchemaUrl(schemaUrl)).withExemplars(OTelProtoStandardCodec.convertExemplars(dp.getExemplarsList()))).withFlags(Integer.valueOf(dp.getFlags()))).withTimeReceived(timeReceived).build()).map(Record::new).collect(Collectors.toList());
        }

        private List<? extends Record<? extends org.opensearch.dataprepper.model.metric.Metric>> mapSum(Metric metric, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, Instant timeReceived) {
            return metric.getSum().getDataPointsList().stream().map(dp -> ((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)JacksonStandardSum.builder().withUnit(metric.getUnit())).withName(metric.getName())).withDescription(metric.getDescription())).withAttributes(this.convertKeyValueToAttributes(dp.getAttributesList()))).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getStartTimeUnixNano()))).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getTimeUnixNano()))).withIsMonotonic(metric.getSum().getIsMonotonic()).withValue(OTelProtoStandardCodec.getValueAsDouble(dp)).withAggregationTemporality(metric.getSum().getAggregationTemporality().toString()).withScope(ils)).withResource(resourceAttributes)).withSchemaUrl(schemaUrl)).withMetricMetadata(this.getMetricMetadata(metric))).withExemplars(OTelProtoStandardCodec.convertExemplars(dp.getExemplarsList()))).withFlags(Integer.valueOf(dp.getFlags()))).withTimeReceived(timeReceived).build()).map(Record::new).collect(Collectors.toList());
        }

        private List<? extends Record<? extends org.opensearch.dataprepper.model.metric.Metric>> mapSummary(Metric metric, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, Instant timeReceived) {
            return metric.getSummary().getDataPointsList().stream().map(dp -> ((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)((JacksonSummary.Builder)JacksonStandardSummary.builder().withUnit(metric.getUnit())).withName(metric.getName())).withDescription(metric.getDescription())).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getStartTimeUnixNano()))).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getTimeUnixNano()))).withCount(Long.valueOf(dp.getCount())).withSum(dp.getSum()).withMetricMetadata(this.getMetricMetadata(metric))).withQuantiles(OTelProtoStandardCodec.getQuantileValues(dp.getQuantileValuesList())).withQuantilesValueCount(dp.getQuantileValuesCount()).withScope(ils)).withResource(resourceAttributes)).withAttributes(this.convertKeyValueToAttributes(dp.getAttributesList()))).withSchemaUrl(schemaUrl)).withFlags(Integer.valueOf(dp.getFlags()))).withTimeReceived(timeReceived).build()).map(Record::new).collect(Collectors.toList());
        }

        private List<? extends Record<? extends org.opensearch.dataprepper.model.metric.Metric>> mapHistogram(Metric metric, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, Instant timeReceived, boolean calculateHistogramBuckets) {
            return metric.getHistogram().getDataPointsList().stream().map(dp -> {
                JacksonHistogram.Builder builder = (JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)JacksonStandardHistogram.builder().withUnit(metric.getUnit())).withName(metric.getName())).withDescription(metric.getDescription())).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getStartTimeUnixNano()))).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getTimeUnixNano()))).withSum(dp.getSum()).withMin(Double.valueOf(dp.getMin())).withMax(Double.valueOf(dp.getMax())).withCount(dp.getCount()).withBucketCount(dp.getBucketCountsCount()).withExplicitBoundsCount(dp.getExplicitBoundsCount()).withAggregationTemporality(metric.getHistogram().getAggregationTemporality().toString()).withBucketCountsList(dp.getBucketCountsList()).withExplicitBoundsList(dp.getExplicitBoundsList()).withMetricMetadata(this.getMetricMetadata(metric))).withScope(ils)).withResource(resourceAttributes)).withAttributes(this.convertKeyValueToAttributes(dp.getAttributesList()))).withSchemaUrl(schemaUrl)).withExemplars(OTelProtoStandardCodec.convertExemplars(dp.getExemplarsList()))).withTimeReceived(timeReceived).withFlags(Integer.valueOf(dp.getFlags()));
                if (calculateHistogramBuckets) {
                    builder.withBuckets(OTelProtoStandardCodec.createBuckets(dp.getBucketCountsList(), dp.getExplicitBoundsList()));
                }
                JacksonHistogram jh = builder.build();
                return jh;
            }).map(Record::new).collect(Collectors.toList());
        }

        private List<? extends Record<? extends org.opensearch.dataprepper.model.metric.Metric>> mapExponentialHistogram(Metric metric, String serviceName, Map<String, Object> ils, Map<String, Object> resourceAttributes, String schemaUrl, Integer exponentialHistogramMaxAllowedScale, Instant timeReceived, boolean calculateExponentialHistogramBuckets) {
            return metric.getExponentialHistogram().getDataPointsList().stream().filter(dp -> {
                if (calculateExponentialHistogramBuckets && exponentialHistogramMaxAllowedScale < Math.abs(dp.getScale())) {
                    LOG.error("Exponential histogram can not be processed since its scale of {} is bigger than the configured max of {}.", (Object)dp.getScale(), (Object)exponentialHistogramMaxAllowedScale);
                    return false;
                }
                return true;
            }).map(dp -> {
                JacksonExponentialHistogram.Builder builder = (JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)((JacksonExponentialHistogram.Builder)JacksonStandardExponentialHistogram.builder().withUnit(metric.getUnit())).withName(metric.getName())).withDescription(metric.getDescription())).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getStartTimeUnixNano()))).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601(dp.getTimeUnixNano()))).withSum(dp.getSum()).withMin(Double.valueOf(dp.getMin())).withMax(Double.valueOf(dp.getMax())).withCount(dp.getCount()).withMetricMetadata(this.getMetricMetadata(metric))).withZeroCount(dp.getZeroCount()).withZeroThreshold(Double.valueOf(dp.getZeroThreshold())).withScale(dp.getScale()).withPositive(dp.getPositive().getBucketCountsList()).withPositiveOffset(dp.getPositive().getOffset()).withNegative(dp.getNegative().getBucketCountsList()).withNegativeOffset(dp.getNegative().getOffset()).withAggregationTemporality(metric.getHistogram().getAggregationTemporality().toString()).withScope(ils)).withResource(resourceAttributes)).withAttributes(this.convertKeyValueToAttributes(dp.getAttributesList()))).withSchemaUrl(schemaUrl)).withExemplars(OTelProtoStandardCodec.convertExemplars(dp.getExemplarsList()))).withTimeReceived(timeReceived).withFlags(Integer.valueOf(dp.getFlags()));
                if (calculateExponentialHistogramBuckets) {
                    builder.withPositiveBuckets(OTelProtoStandardCodec.createExponentialBuckets(dp.getPositive(), dp.getScale()));
                    builder.withNegativeBuckets(OTelProtoStandardCodec.createExponentialBuckets(dp.getNegative(), dp.getScale()));
                }
                return builder.build();
            }).map(Record::new).collect(Collectors.toList());
        }
    }

    static class BoundsKey {
        private final Integer scale;
        private final Sign sign;

        public BoundsKey(Integer scale, Sign sign) {
            this.scale = scale;
            this.sign = sign;
        }

        public Integer getScale() {
            return this.scale;
        }

        public Sign getSign() {
            return this.sign;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundsKey boundsKey = (BoundsKey)o;
            return this.scale.equals(boundsKey.scale) && this.sign == boundsKey.sign;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.scale, this.sign});
        }

        public static enum Sign {
            POSITIVE,
            NEGATIVE;

        }
    }
}

