/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.otellogs;

import com.linecorp.armeria.server.Server;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.opentelemetry.proto.collector.logs.v1.LogsServiceGrpc;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.opensearch.dataprepper.armeria.authentication.GrpcAuthenticationProvider;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.codec.ByteDecoder;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.certificate.CertificateProvider;
import org.opensearch.dataprepper.plugins.otel.codec.OTelLogsDecoder;
import org.opensearch.dataprepper.plugins.otel.codec.OTelOutputFormat;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoOpensearchCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoStandardCodec;
import org.opensearch.dataprepper.plugins.server.CreateServer;
import org.opensearch.dataprepper.plugins.server.ServerConfiguration;
import org.opensearch.dataprepper.plugins.source.otellogs.ConvertConfiguration;
import org.opensearch.dataprepper.plugins.source.otellogs.OTelLogsGrpcService;
import org.opensearch.dataprepper.plugins.source.otellogs.OTelLogsSourceConfig;
import org.opensearch.dataprepper.plugins.source.otellogs.certificate.CertificateProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="otel_logs_source", pluginType=Source.class, pluginConfigurationType=OTelLogsSourceConfig.class)
public class OTelLogsSource
implements Source<Record<Object>> {
    private static final String PLUGIN_NAME = "otel_logs_source";
    private static final Logger LOG = LoggerFactory.getLogger(OTelLogsSource.class);
    static final String SERVER_CONNECTIONS = "serverConnections";
    private final OTelLogsSourceConfig oTelLogsSourceConfig;
    private final String pipelineName;
    private final PluginMetrics pluginMetrics;
    private final GrpcAuthenticationProvider authenticationProvider;
    private final CertificateProviderFactory certificateProviderFactory;
    private final ByteDecoder byteDecoder;
    private Server server;

    @DataPrepperPluginConstructor
    public OTelLogsSource(OTelLogsSourceConfig oTelLogsSourceConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, PipelineDescription pipelineDescription) {
        this(oTelLogsSourceConfig, pluginMetrics, pluginFactory, new CertificateProviderFactory(oTelLogsSourceConfig), pipelineDescription);
    }

    OTelLogsSource(OTelLogsSourceConfig oTelLogsSourceConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, CertificateProviderFactory certificateProviderFactory, PipelineDescription pipelineDescription) {
        oTelLogsSourceConfig.validateAndInitializeCertAndKeyFileInS3();
        this.oTelLogsSourceConfig = oTelLogsSourceConfig;
        this.pluginMetrics = pluginMetrics;
        this.certificateProviderFactory = certificateProviderFactory;
        this.pipelineName = pipelineDescription.getPipelineName();
        this.authenticationProvider = this.createAuthenticationProvider(pluginFactory);
        this.byteDecoder = new OTelLogsDecoder(oTelLogsSourceConfig.getOutputFormat());
    }

    public ByteDecoder getDecoder() {
        return this.byteDecoder;
    }

    public void start(Buffer<Record<Object>> buffer) {
        if (buffer == null) {
            throw new IllegalStateException("Buffer provided is null");
        }
        if (this.server == null) {
            OTelLogsGrpcService oTelLogsGrpcService = new OTelLogsGrpcService((int)((double)this.oTelLogsSourceConfig.getRequestTimeoutInMillis() * 0.8), (OTelProtoCodec.OTelProtoDecoder)(this.oTelLogsSourceConfig.getOutputFormat() == OTelOutputFormat.OPENSEARCH ? new OTelProtoOpensearchCodec.OTelProtoDecoder() : new OTelProtoStandardCodec.OTelProtoDecoder()), buffer, this.pluginMetrics, null);
            ServerConfiguration serverConfiguration = ConvertConfiguration.convertConfiguration(this.oTelLogsSourceConfig);
            CreateServer createServer = new CreateServer(serverConfiguration, LOG, this.pluginMetrics, PLUGIN_NAME, this.pipelineName);
            CertificateProvider certificateProvider = null;
            if (this.oTelLogsSourceConfig.isSsl() || this.oTelLogsSourceConfig.useAcmCertForSSL()) {
                certificateProvider = this.certificateProviderFactory.getCertificateProvider();
            }
            MethodDescriptor methodDescriptor = LogsServiceGrpc.getExportMethod();
            this.server = createServer.createGRPCServer(this.authenticationProvider, (BindableService)oTelLogsGrpcService, certificateProvider, methodDescriptor);
            this.pluginMetrics.gauge(SERVER_CONNECTIONS, (Object)this.server, Server::numConnections);
        }
        try {
            this.server.start().get();
        }
        catch (ExecutionException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        LOG.info("Started otel_logs_source...");
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop().get();
            }
            catch (ExecutionException ex) {
                if (ex.getCause() != null && ex.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getCause();
                }
                throw new RuntimeException(ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
        }
        LOG.info("Stopped otel_logs_source.");
    }

    private GrpcAuthenticationProvider createAuthenticationProvider(PluginFactory pluginFactory) {
        PluginModel authenticationConfiguration = this.oTelLogsSourceConfig.getAuthentication();
        if (authenticationConfiguration == null || authenticationConfiguration.getPluginName().equals("unauthenticated")) {
            LOG.warn("Creating otel-logs-source without authentication. This is not secure.");
            LOG.warn("In order to set up Http Basic authentication for the otel-logs-source, go here: https://github.com/opensearch-project/data-prepper/tree/main/data-prepper-plugins/otel-logs-source#authentication-configurations");
        }
        PluginSetting authenticationPluginSetting = authenticationConfiguration != null ? new PluginSetting(authenticationConfiguration.getPluginName(), authenticationConfiguration.getPluginSettings()) : new PluginSetting("unauthenticated", Collections.emptyMap());
        authenticationPluginSetting.setPipelineName(this.pipelineName);
        return (GrpcAuthenticationProvider)pluginFactory.loadPlugin(GrpcAuthenticationProvider.class, authenticationPluginSetting, new Object[0]);
    }
}

