/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.everit.json.schema.loader.JsonArrayIterator;
import org.everit.json.schema.loader.JsonValue;

final class JsonArray
extends JsonValue {
    private List<Object> storage;

    JsonArray(List<Object> storage) {
        super(storage);
        this.storage = Objects.requireNonNull(storage, "storage cannot be null");
    }

    public void forEach(JsonArrayIterator iterator) {
        for (int i = 0; i < this.storage.size(); ++i) {
            JsonValue childValue = this.at(i);
            iterator.apply(i, childValue);
        }
    }

    protected JsonValue at(int i) {
        return this.ls.childFor(i);
    }

    public int length() {
        return this.storage.size();
    }

    @Override
    public <R> R requireArray(Function<JsonArray, R> mapper) {
        return mapper.apply(this);
    }

    @Override
    protected Class<?> typeOfValue() {
        return JsonArray.class;
    }

    @Override
    protected Object value() {
        return this;
    }

    @Override
    protected Object unwrap() {
        return new ArrayList<Object>(this.storage);
    }
}

