/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.docs.DefaultTypeSignature;
import com.linecorp.armeria.server.docs.TypeSignatureType;
import java.util.Objects;
import java.util.regex.Pattern;

@UnstableApi
public class DescriptiveTypeSignature
extends DefaultTypeSignature {
    static final Pattern NAMED_PATTERN = Pattern.compile("^([^.<>]+(?:\\.[^.<>]+)+)$");
    private final Object descriptor;

    DescriptiveTypeSignature(TypeSignatureType type, Class<?> descriptor) {
        super(type, descriptor.getName());
        assert (type.hasTypeDescriptor());
        String typeName = descriptor.getName();
        Preconditions.checkArgument(NAMED_PATTERN.matcher(typeName).matches(), "%s: %s", descriptor, (Object)typeName);
        Preconditions.checkArgument(!descriptor.isArray(), "%s is an array: %s", descriptor, (Object)typeName);
        Preconditions.checkArgument(!descriptor.isPrimitive(), "%s is a primitive type: %s", descriptor, (Object)typeName);
        this.descriptor = descriptor;
    }

    protected DescriptiveTypeSignature(TypeSignatureType type, String name, Object descriptor) {
        super(type, name);
        this.descriptor = descriptor;
    }

    public Object descriptor() {
        return this.descriptor;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DescriptiveTypeSignature)) {
            return false;
        }
        DescriptiveTypeSignature that = (DescriptiveTypeSignature)o;
        return this.type() == that.type() && this.name().equals(that.name()) && Objects.equals(this.descriptor, that.descriptor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type(), this.name(), this.descriptor});
    }
}

