/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.stream.AggregationSupport;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilteredStreamMessage<T, U>
extends AggregationSupport
implements StreamMessage<U> {
    private static final Logger logger = LoggerFactory.getLogger(FilteredStreamMessage.class);
    private final CompletableFuture<Void> completionFuture = new CompletableFuture();
    private final StreamMessage<T> upstream;
    private final boolean filterSupportsPooledObjects;

    protected FilteredStreamMessage(StreamMessage<T> upstream) {
        this(upstream, false);
    }

    @UnstableApi
    protected FilteredStreamMessage(StreamMessage<T> upstream, boolean withPooledObjects) {
        this.upstream = Objects.requireNonNull(upstream, "upstream");
        this.filterSupportsPooledObjects = withPooledObjects;
    }

    protected abstract U filter(T var1);

    protected void beforeSubscribe(Subscriber<? super U> subscriber, Subscription subscription) {
    }

    protected void beforeComplete(Subscriber<? super U> subscriber) {
    }

    @Nullable
    protected Throwable beforeError(Subscriber<? super U> subscriber, Throwable cause) {
        return cause;
    }

    protected void onCancellation(Subscriber<? super U> subscriber) {
    }

    @Override
    public final boolean isOpen() {
        return this.upstream.isOpen();
    }

    @Override
    public final boolean isEmpty() {
        return this.upstream.isEmpty();
    }

    @Override
    public final long demand() {
        return this.upstream.demand();
    }

    @Override
    public final CompletableFuture<Void> whenComplete() {
        return this.completionFuture;
    }

    @Override
    public final void subscribe(Subscriber<? super U> subscriber, EventExecutor executor) {
        this.subscribe(subscriber, executor, false, false);
    }

    @Override
    public final void subscribe(Subscriber<? super U> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        boolean withPooledObjects = InternalStreamMessageUtil.containsWithPooledObjects(options);
        boolean notifyCancellation = InternalStreamMessageUtil.containsNotifyCancellation(options);
        this.subscribe(subscriber, executor, withPooledObjects, notifyCancellation);
    }

    private void subscribe(Subscriber<? super U> subscriber, EventExecutor executor, boolean withPooledObjects, boolean notifyCancellation) {
        FilteringSubscriber filteringSubscriber = new FilteringSubscriber(subscriber, withPooledObjects);
        SubscriptionOption[] options = InternalStreamMessageUtil.toSubscriptionOptions(this.filterSupportsPooledObjects, notifyCancellation);
        this.upstream.subscribe(filteringSubscriber, executor, options);
    }

    @Override
    public final EventExecutor defaultSubscriberExecutor() {
        return this.upstream.defaultSubscriberExecutor();
    }

    @Override
    public final void abort() {
        this.upstream.abort();
    }

    @Override
    public final void abort(Throwable cause) {
        this.upstream.abort(Objects.requireNonNull(cause, "cause"));
    }

    private final class FilteringSubscriber
    implements Subscriber<T>,
    Subscription {
        private final Subscriber<? super U> delegate;
        private final boolean subscribedWithPooledObjects;
        private boolean completed;
        @Nullable
        private Subscription upstream;

        FilteringSubscriber(Subscriber<? super U> delegate, boolean subscribedWithPooledObjects) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
            this.subscribedWithPooledObjects = subscribedWithPooledObjects;
        }

        public void request(long n) {
            assert (this.upstream != null);
            this.upstream.request(n);
        }

        public void cancel() {
            assert (this.upstream != null);
            FilteredStreamMessage.this.onCancellation(this.delegate);
            FilteredStreamMessage.this.completionFuture.completeExceptionally(CancelledSubscriptionException.get());
            this.upstream.cancel();
        }

        public void onSubscribe(Subscription s) {
            this.upstream = s;
            try {
                FilteredStreamMessage.this.beforeSubscribe(this.delegate, this);
            }
            catch (Throwable ex) {
                s.cancel();
                logger.warn("Unexpected exception from {}#beforeSubscribe()", (Object)FilteredStreamMessage.this.getClass().getName(), (Object)ex);
                return;
            }
            this.delegate.onSubscribe((Subscription)this);
        }

        public void onNext(T o) {
            Object filtered;
            try {
                filtered = FilteredStreamMessage.this.filter(o);
            }
            catch (Throwable ex) {
                this.onError(ex);
                assert (this.upstream != null);
                this.upstream.cancel();
                return;
            }
            if (this.completed) {
                StreamMessageUtil.closeOrAbort(filtered);
                return;
            }
            if (!this.subscribedWithPooledObjects) {
                filtered = PooledObjects.copyAndClose(filtered);
            }
            this.delegate.onNext(filtered);
        }

        public void onError(Throwable t) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            Throwable filteredCause = FilteredStreamMessage.this.beforeError(this.delegate, t);
            if (filteredCause != null) {
                this.delegate.onError(filteredCause);
                FilteredStreamMessage.this.completionFuture.completeExceptionally(filteredCause);
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn("{}#beforeError() returned null. Using the original exception: {}", (Object)FilteredStreamMessage.this.getClass().getName(), (Object)t.toString());
                }
                this.delegate.onError(t);
                FilteredStreamMessage.this.completionFuture.completeExceptionally(t);
            }
        }

        public void onComplete() {
            if (this.completed) {
                return;
            }
            this.completed = true;
            try {
                FilteredStreamMessage.this.beforeComplete(this.delegate);
                this.delegate.onComplete();
                FilteredStreamMessage.this.completionFuture.complete(null);
            }
            catch (Exception cause) {
                this.delegate.onError((Throwable)cause);
                FilteredStreamMessage.this.completionFuture.completeExceptionally(cause);
            }
        }
    }
}

