/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeyWriter;

class LocalDirectoryEncryptedDataKeyWriter
implements EncryptedDataKeyWriter {
    private static final String KEY_NAME_FORMAT = "%s.key";
    private final Path encryptionKeyDirectory;

    public LocalDirectoryEncryptedDataKeyWriter(String encryptionKeyDirectory) {
        this.encryptionKeyDirectory = Path.of(encryptionKeyDirectory, new String[0]);
    }

    @Override
    public void writeEncryptedDataKey(String encryptedDataKey) throws IOException {
        if (!Files.exists(this.encryptionKeyDirectory, new LinkOption[0])) {
            Files.createDirectories(this.encryptionKeyDirectory, new FileAttribute[0]);
        }
        Path keyFile = this.encryptionKeyDirectory.resolve(this.buildKey());
        Files.writeString(keyFile, (CharSequence)encryptedDataKey, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private String buildKey() {
        Instant now = Instant.now();
        return String.format(KEY_NAME_FORMAT, DateTimeFormatter.ISO_INSTANT.format(now));
    }
}

