/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.opensearch.dataprepper.model.encryption.EncryptionEngine;
import org.opensearch.dataprepper.model.encryption.EncryptionEnvelope;
import org.opensearch.dataprepper.model.encryption.KeyProvider;
import org.opensearch.dataprepper.plugins.encryption.DefaultEncryptionEnvelope;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeySupplier;
import org.opensearch.dataprepper.plugins.encryption.EncryptionContext;

class DefaultEncryptionEngine
implements EncryptionEngine {
    private final EncryptionContext encryptionContext;
    private final KeyProvider keyProvider;
    private final EncryptedDataKeySupplier encryptedDataKeySupplier;

    public DefaultEncryptionEngine(KeyProvider keyProvider, EncryptionContext encryptionContext, EncryptedDataKeySupplier encryptedDataKeySupplier) {
        this.keyProvider = keyProvider;
        this.encryptionContext = encryptionContext;
        this.encryptedDataKeySupplier = encryptedDataKeySupplier;
    }

    public EncryptionEnvelope encrypt(byte[] data) {
        String encryptedDataKey = this.encryptedDataKeySupplier.retrieveValue();
        byte[] decodedEncryptionKey = Base64.getDecoder().decode(encryptedDataKey);
        byte[] unencryptedDataKey = this.keyProvider.decryptKey(decodedEncryptionKey);
        Cipher encryptionCipher = this.encryptionContext.getOrCreateEncryptionCipher(unencryptedDataKey);
        try {
            byte[] encryptedData = encryptionCipher.doFinal(data);
            return DefaultEncryptionEnvelope.builder().encryptedData(encryptedData).encryptedDataKey(encryptedDataKey).build();
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] decrypt(EncryptionEnvelope encryptionEnvelope) {
        byte[] decodedEncryptionKey = Base64.getDecoder().decode(encryptionEnvelope.getEncryptedDataKey());
        byte[] unencryptedDataKey = this.keyProvider.decryptKey(decodedEncryptionKey);
        Cipher decryptionCipher = this.encryptionContext.getOrCreateDecryptionCipher(unencryptedDataKey);
        try {
            return decryptionCipher.doFinal(encryptionEnvelope.getEncryptedData());
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }
}

