/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutatestring;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.plugins.processor.mutatestring.AbstractStringProcessor;
import org.opensearch.dataprepper.plugins.processor.mutatestring.SubstituteStringProcessorConfig;

@DataPrepperPlugin(name="substitute_string", pluginType=Processor.class, pluginConfigurationType=SubstituteStringProcessorConfig.class)
public class SubstituteStringProcessor
extends AbstractStringProcessor<SubstituteStringProcessorConfig.Entry> {
    private final Map<String, Pattern> patternMap = new HashMap<String, Pattern>();
    private final ExpressionEvaluator expressionEvaluator;

    @DataPrepperPluginConstructor
    public SubstituteStringProcessor(PluginMetrics pluginMetrics, SubstituteStringProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics, config);
        this.expressionEvaluator = expressionEvaluator;
        for (SubstituteStringProcessorConfig.Entry entry : config.getEntries()) {
            this.patternMap.put(entry.getFrom(), Pattern.compile(entry.getFrom()));
            if (entry.getSubstituteWhen() == null || expressionEvaluator.isValidExpressionStatement(entry.getSubstituteWhen()).booleanValue()) continue;
            throw new InvalidPluginConfigurationException(String.format("substitute_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", entry.getSubstituteWhen()));
        }
    }

    @Override
    protected void performKeyAction(Event recordEvent, SubstituteStringProcessorConfig.Entry entry, String value) {
        if (Objects.nonNull(entry.getSubstituteWhen()) && !this.expressionEvaluator.evaluateConditional(entry.getSubstituteWhen(), recordEvent).booleanValue()) {
            return;
        }
        Pattern pattern = this.patternMap.get(entry.getFrom());
        Matcher matcher = pattern.matcher(value);
        String newValue = matcher.replaceAll(entry.getTo());
        recordEvent.put(entry.getSource(), (Object)newValue);
    }

    @Override
    protected EventKey getKey(SubstituteStringProcessorConfig.Entry entry) {
        return entry.getSource();
    }
}

