/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutatestring;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.AlsoRequired;
import org.opensearch.dataprepper.model.annotations.ConditionalRequired;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.model.annotations.ValidRegex;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.plugins.processor.mutatestring.StringProcessorConfig;

@ConditionalRequired(value={@ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="delimiter", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="delimiter_regex")}), @ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="delimiter_regex", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="delimiter")})})
@JsonPropertyOrder
@JsonClassDescription(value="The <code>split_string</code> processor splits a field into an array using a delimiting character.")
public class SplitStringProcessorConfig
implements StringProcessorConfig<Entry> {
    @JsonPropertyDescription(value="List of entries. Each entry defines a split.")
    private @NotNull List<@Valid Entry> entries;

    @Override
    @JsonIgnore
    public List<Entry> getIterativeConfig() {
        return this.entries;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    @JsonPropertyOrder
    public static class Entry {
        static final String DELIMITER_REGEX_KEY = "delimiter_regex";
        @NotEmpty
        @NotNull
        @JsonPropertyDescription(value="The key name of the field to split.")
        private EventKey source;
        @Size(min=1, max=1)
        @JsonPropertyDescription(value="The separator character responsible for the split. Cannot be defined at the same time as <code>delimiter_regex</code>. At least <code>delimiter</code> or <code>delimiter_regex</code> must be defined.")
        @AlsoRequired(values={@AlsoRequired.Required(name="delimiter_regex", allowedValues={"null", "\"\""})})
        @ExampleValues(value={@ExampleValues.Example(value="/", description="Split a file path.")})
        private @Size(min=1, max=1) String delimiter;
        @ValidRegex(message="The value of delimiter_regex is not a valid regex string")
        @JsonProperty(value="delimiter_regex")
        @JsonPropertyDescription(value="The regex string responsible for the split. Cannot be defined at the same time as <code>delimiter</code>. At least <code>delimiter</code> or <code>delimiter_regex</code> must be defined.")
        @AlsoRequired(values={@AlsoRequired.Required(name="delimiter", allowedValues={"null", "\"\""})})
        @ExampleValues(value={@ExampleValues.Example(value="(file:///|/+)", description="Split a file URI, treating multiple slashes as a single slash.")})
        private String delimiterRegex;
        @JsonProperty(value="split_when")
        @JsonPropertyDescription(value="Specifies under what condition the <code>split_string</code> processor should perform splitting. Default is no condition.")
        @ExampleValues(value={@ExampleValues.Example(value="startsWith(/path, \"file://\")", description="Split a string only if it starts with the file URI scheme.")})
        private String splitWhen;

        public EventKey getSource() {
            return this.source;
        }

        public String getDelimiterRegex() {
            return this.delimiterRegex;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public String getSplitWhen() {
            return this.splitWhen;
        }

        public Entry(EventKey source, String delimiterRegex, String delimiter, String splitWhen) {
            this.source = source;
            this.delimiterRegex = delimiterRegex;
            this.delimiter = delimiter;
            this.splitWhen = splitWhen;
        }

        public Entry() {
        }
    }
}

