/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.Incident;
import com.microsoft.graph.security.requests.IncidentCollectionPage;
import com.microsoft.graph.security.requests.IncidentCollectionRequestBuilder;
import com.microsoft.graph.security.requests.IncidentCollectionResponse;
import com.microsoft.graph.security.requests.IncidentRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IncidentCollectionRequest
extends BaseEntityCollectionRequest<Incident, IncidentCollectionResponse, IncidentCollectionPage> {
    public IncidentCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, IncidentCollectionResponse.class, IncidentCollectionPage.class, IncidentCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Incident> postAsync(@Nonnull Incident newIncident) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new IncidentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newIncident);
    }

    @Nonnull
    public Incident post(@Nonnull Incident newIncident) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new IncidentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newIncident);
    }

    @Nonnull
    public IncidentCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public IncidentCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public IncidentCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public IncidentCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public IncidentCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public IncidentCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public IncidentCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public IncidentCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public IncidentCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

