/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.AppScope;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AppScopeRequest
extends BaseRequest<AppScope> {
    public AppScopeRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AppScope.class);
    }

    @Nonnull
    public CompletableFuture<AppScope> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public AppScope get() throws ClientException {
        return (AppScope)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<AppScope> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public AppScope delete() throws ClientException {
        return (AppScope)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<AppScope> patchAsync(@Nonnull AppScope sourceAppScope) {
        return this.sendAsync(HttpMethod.PATCH, sourceAppScope);
    }

    @Nullable
    public AppScope patch(@Nonnull AppScope sourceAppScope) throws ClientException {
        return (AppScope)this.send(HttpMethod.PATCH, sourceAppScope);
    }

    @Nonnull
    public CompletableFuture<AppScope> postAsync(@Nonnull AppScope newAppScope) {
        return this.sendAsync(HttpMethod.POST, newAppScope);
    }

    @Nullable
    public AppScope post(@Nonnull AppScope newAppScope) throws ClientException {
        return (AppScope)this.send(HttpMethod.POST, newAppScope);
    }

    @Nonnull
    public CompletableFuture<AppScope> putAsync(@Nonnull AppScope newAppScope) {
        return this.sendAsync(HttpMethod.PUT, newAppScope);
    }

    @Nullable
    public AppScope put(@Nonnull AppScope newAppScope) throws ClientException {
        return (AppScope)this.send(HttpMethod.PUT, newAppScope);
    }

    @Nonnull
    public AppScopeRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public AppScopeRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

