/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.decompress;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.codec.DecompressionEngine;
import org.opensearch.dataprepper.plugins.codec.GZipDecompressionEngine;
import org.opensearch.dataprepper.plugins.processor.decompress.DecompressionEngineFactory;

public enum DecompressionType implements DecompressionEngineFactory
{
    GZIP("gzip");

    private final String option;
    private static final Map<String, DecompressionType> OPTIONS_MAP;
    private static final Map<String, DecompressionEngine> DECOMPRESSION_ENGINE_MAP;

    private DecompressionType(String option) {
        this.option = option;
    }

    @JsonCreator
    static DecompressionType fromOptionValue(String option) {
        return OPTIONS_MAP.get(option);
    }

    @JsonValue
    public String getOptionValue() {
        return this.option;
    }

    @Override
    public DecompressionEngine getDecompressionEngine() {
        return DECOMPRESSION_ENGINE_MAP.get(this.option);
    }

    static {
        OPTIONS_MAP = Arrays.stream(DecompressionType.values()).collect(Collectors.toMap(value -> value.option, value -> value));
        DECOMPRESSION_ENGINE_MAP = Map.of("gzip", new GZipDecompressionEngine());
    }
}

