/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.dissect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.plugins.processor.dissect.Delimiter;
import org.opensearch.dataprepper.plugins.processor.dissect.Fields.AppendField;
import org.opensearch.dataprepper.plugins.processor.dissect.Fields.Field;
import org.opensearch.dataprepper.plugins.processor.dissect.Fields.FieldHelper;
import org.opensearch.dataprepper.plugins.processor.dissect.Fields.IndirectField;
import org.opensearch.dataprepper.plugins.processor.dissect.Fields.NormalField;
import org.opensearch.dataprepper.plugins.processor.dissect.Fields.SkipField;

public class Dissector {
    private Map<String, SkipField> skipFieldMap;
    private Map<String, NormalField> normalFieldMap;
    private Map<String, IndirectField> indirectFieldMap;
    private Map<String, List<AppendField>> unAppendedFieldsMap;
    private final FieldHelper fieldHelper = new FieldHelper();
    private final LinkedList<Field> fieldsList = new LinkedList();
    private final LinkedList<Delimiter> delimiterList = new LinkedList();
    private static final Pattern DISSECT_PATTERN = Pattern.compile("%\\{([^}]*)}");

    public Dissector(String dissectPatternString) {
        int maxLength = dissectPatternString.length() / 3;
        String[] delimiterArray = new String[maxLength];
        String[] fieldsArray = new String[maxLength];
        int lastIndex = 0;
        int fieldIndex = 0;
        int delimIndex = 0;
        Matcher matcher = DISSECT_PATTERN.matcher(dissectPatternString);
        while (matcher.find()) {
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            delimiterArray[delimIndex] = dissectPatternString.substring(lastIndex, matchStart);
            fieldsArray[fieldIndex] = matcher.group(1);
            ++delimIndex;
            ++fieldIndex;
            lastIndex = matchEnd;
        }
        if (lastIndex < dissectPatternString.length()) {
            delimiterArray[delimIndex] = dissectPatternString.substring(lastIndex);
        }
        this.parseFields(fieldsArray);
        this.parseDelimiters(delimiterArray);
        this.setFieldsMaps();
    }

    public boolean dissectText(String text) {
        try {
            if (!this.setDelimiterIndexes(text)) {
                return false;
            }
            Field head = this.fieldsList.getFirst();
            for (Delimiter delimiter : this.delimiterList) {
                int fieldStart = 0;
                int fieldEnd = delimiter.getStart();
                if (delimiter.getPrev() == null && delimiter.getStart() == 0) continue;
                if (delimiter.getPrev() != null || delimiter.getStart() == 0) {
                    fieldStart = delimiter.getPrev().getEnd() + 1;
                }
                head.setValue(text.substring(fieldStart, fieldEnd));
                head = head.getNext();
            }
            if (this.delimiterList.getLast().getEnd() != text.length() - 1) {
                int fieldStart = this.delimiterList.getLast().getEnd() + 1;
                int fieldEnd = text.length();
                head.setValue(text.substring(fieldStart, fieldEnd));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<Field> getDissectedFields() {
        ArrayList<Field> dissectedFields = new ArrayList<Field>();
        Map<String, AppendField> appendFieldMap = this.getAppendedFields(this.unAppendedFieldsMap);
        dissectedFields.addAll(this.normalFieldMap.values());
        dissectedFields.addAll(appendFieldMap.values());
        for (Field field : this.indirectFieldMap.values()) {
            if (this.normalFieldMap.containsKey(field.getKey())) {
                field.setKey(this.normalFieldMap.get(field.getKey()).getValue());
            }
            if (this.skipFieldMap.containsKey(field.getKey())) {
                field.setKey(this.skipFieldMap.get(field.getKey()).getValue());
            }
            if (appendFieldMap.containsKey(field.getKey())) {
                field.setKey(appendFieldMap.get(field.getKey()).getValue());
            }
            dissectedFields.add(field);
        }
        return dissectedFields;
    }

    private void setFieldsMaps() {
        this.normalFieldMap = this.fieldHelper.getNormalFieldMap();
        this.skipFieldMap = this.fieldHelper.getSkipFieldMap();
        this.indirectFieldMap = this.fieldHelper.getIndirectFieldMap();
        this.unAppendedFieldsMap = this.fieldHelper.getAppendFieldMap();
    }

    private void parseFields(String[] fieldsArray) {
        for (String fieldString : fieldsArray) {
            if (fieldString == null) {
                return;
            }
            Field field = this.fieldHelper.getField(fieldString);
            if (this.fieldsList.size() == 0) {
                this.fieldsList.addLast(field);
                continue;
            }
            this.fieldsList.getLast().setNext(field);
            this.fieldsList.addLast(field);
        }
    }

    private void parseDelimiters(String[] delimiterArray) {
        for (String delimiterString : delimiterArray) {
            if (delimiterString == null) {
                return;
            }
            if (delimiterString.length() == 0) continue;
            Delimiter delimiter = new Delimiter(delimiterString);
            if (this.delimiterList.size() == 0) {
                this.delimiterList.addLast(delimiter);
                continue;
            }
            this.delimiterList.getLast().setNext(delimiter);
            delimiter.setPrev(this.delimiterList.getLast());
            this.delimiterList.addLast(delimiter);
        }
    }

    private boolean setDelimiterIndexes(String text) {
        for (Delimiter delimiter : this.delimiterList) {
            int prevEnd = 0;
            if (delimiter.getPrev() != null) {
                prevEnd = delimiter.getPrev().getEnd() + 1;
            }
            String delimiterString = delimiter.toString();
            int start = text.indexOf(delimiterString, prevEnd);
            if (delimiterString.trim().isEmpty()) {
                start += this.findLastWhitespaceIndex(text.substring(start), delimiterString.length());
            }
            int end = start + delimiterString.length() - 1;
            if (start < 0 || end > text.length()) {
                return false;
            }
            delimiter.setStart(start);
            delimiter.setEnd(end);
        }
        return true;
    }

    private Map<String, AppendField> getAppendedFields(Map<String, List<AppendField>> unAppendedFieldsMap) {
        HashMap<String, AppendField> appendFieldMap = new HashMap<String, AppendField>();
        for (String key : unAppendedFieldsMap.keySet()) {
            List<AppendField> appendFields = unAppendedFieldsMap.get(key);
            Collections.sort(appendFields);
            String value = appendFields.stream().map(Field::getValue).collect(Collectors.joining());
            AppendField sortedField = new AppendField(key);
            sortedField.setValue(value);
            appendFieldMap.put(sortedField.getKey(), sortedField);
        }
        return appendFieldMap;
    }

    private int findLastWhitespaceIndex(String s, int w) {
        String[] leadingSpaces = s.split("\\S", 2);
        if (leadingSpaces.length > 0 && leadingSpaces[0].length() >= w) {
            return leadingSpaces[0].length() - w;
        }
        return 0;
    }
}

