/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.model.types.ByteCount;

public class PrometheusSinkThresholdConfig {
    public static final int DEFAULT_MAX_EVENTS = 1000;
    public static final String DEFAULT_MAX_REQUEST_SIZE = "1mb";
    public static final long DEFAULT_FLUSH_INTERVAL_SECONDS = 10L;
    @JsonProperty(value="max_events")
    @Size(min=1, max=10000, message="max_events should be between 1 to 10000")
    private @Size(min=1, max=10000, message="max_events should be between 1 to 10000") int maxEvents = 1000;
    @JsonProperty(value="max_request_size")
    private ByteCount maxRequestSize = ByteCount.parse((String)"1mb");
    @JsonProperty(value="flush_interval")
    @DurationMin(seconds=1L)
    @DurationMax(seconds=60L)
    private @DurationMin(seconds=1L) @DurationMax(seconds=60L) Duration flushInterval = Duration.ofSeconds(10L);

    public int getMaxEvents() {
        return this.maxEvents;
    }

    public long getMaxRequestSizeBytes() {
        return this.maxRequestSize.getBytes();
    }

    public long getFlushInterval() {
        return this.flushInterval.getSeconds();
    }

    public long getFlushIntervalMs() {
        return this.flushInterval.toMillis();
    }
}

