/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GeoIpProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String databaseFile;
    private final String field;
    private final boolean firstOnly;
    private final boolean ignoreMissing;
    private final List<String> properties;
    private final String targetField;
    public static final JsonpDeserializer<GeoIpProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoIpProcessor::setupGeoIpProcessorDeserializer);

    private GeoIpProcessor(Builder builder) {
        super(builder);
        this.databaseFile = ApiTypeHelper.requireNonNull(builder.databaseFile, this, "databaseFile");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.firstOnly = ApiTypeHelper.requireNonNull(builder.firstOnly, this, "firstOnly");
        this.ignoreMissing = ApiTypeHelper.requireNonNull(builder.ignoreMissing, this, "ignoreMissing");
        this.properties = ApiTypeHelper.unmodifiableRequired(builder.properties, (Object)this, "properties");
        this.targetField = ApiTypeHelper.requireNonNull(builder.targetField, this, "targetField");
    }

    public static GeoIpProcessor of(Function<Builder, ObjectBuilder<GeoIpProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Geoip;
    }

    public final String databaseFile() {
        return this.databaseFile;
    }

    public final String field() {
        return this.field;
    }

    public final boolean firstOnly() {
        return this.firstOnly;
    }

    public final boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public final List<String> properties() {
        return this.properties;
    }

    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("database_file");
        generator.write(this.databaseFile);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("first_only");
        generator.write(this.firstOnly);
        generator.writeKey("ignore_missing");
        generator.write(this.ignoreMissing);
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartArray();
            for (String item0 : this.properties) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("target_field");
        generator.write(this.targetField);
    }

    protected static void setupGeoIpProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::databaseFile, JsonpDeserializer.stringDeserializer(), "database_file");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::firstOnly, JsonpDeserializer.booleanDeserializer(), "first_only");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::properties, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "properties");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoIpProcessor> {
        private String databaseFile;
        private String field;
        private Boolean firstOnly;
        private Boolean ignoreMissing;
        private List<String> properties;
        private String targetField;

        public final Builder databaseFile(String value) {
            this.databaseFile = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder firstOnly(boolean value) {
            this.firstOnly = value;
            return this;
        }

        public final Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder properties(List<String> list) {
            this.properties = Builder._listAddAll(this.properties, list);
            return this;
        }

        public final Builder properties(String value, String ... values) {
            this.properties = Builder._listAdd(this.properties, value, values);
            return this;
        }

        public final Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoIpProcessor build() {
            this._checkSingleUse();
            return new GeoIpProcessor(this);
        }
    }
}

