/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.BulkIndexByScrollFailure;
import co.elastic.clients.elasticsearch._types.Retries;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DeleteByQueryResponse
implements JsonpSerializable {
    @Nullable
    private final Long batches;
    @Nullable
    private final Long deleted;
    private final List<BulkIndexByScrollFailure> failures;
    @Nullable
    private final Long noops;
    @Nullable
    private final Float requestsPerSecond;
    @Nullable
    private final Retries retries;
    @Nullable
    private final Integer sliceId;
    @Nullable
    private final String task;
    @Nullable
    private final Long throttledMillis;
    @Nullable
    private final Long throttledUntilMillis;
    @Nullable
    private final Boolean timedOut;
    @Nullable
    private final Long took;
    @Nullable
    private final Long total;
    @Nullable
    private final Long versionConflicts;
    public static final JsonpDeserializer<DeleteByQueryResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DeleteByQueryResponse::setupDeleteByQueryResponseDeserializer);

    private DeleteByQueryResponse(Builder builder) {
        this.batches = builder.batches;
        this.deleted = builder.deleted;
        this.failures = ApiTypeHelper.unmodifiable(builder.failures);
        this.noops = builder.noops;
        this.requestsPerSecond = builder.requestsPerSecond;
        this.retries = builder.retries;
        this.sliceId = builder.sliceId;
        this.task = builder.task;
        this.throttledMillis = builder.throttledMillis;
        this.throttledUntilMillis = builder.throttledUntilMillis;
        this.timedOut = builder.timedOut;
        this.took = builder.took;
        this.total = builder.total;
        this.versionConflicts = builder.versionConflicts;
    }

    public static DeleteByQueryResponse of(Function<Builder, ObjectBuilder<DeleteByQueryResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long batches() {
        return this.batches;
    }

    @Nullable
    public final Long deleted() {
        return this.deleted;
    }

    public final List<BulkIndexByScrollFailure> failures() {
        return this.failures;
    }

    @Nullable
    public final Long noops() {
        return this.noops;
    }

    @Nullable
    public final Float requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nullable
    public final Retries retries() {
        return this.retries;
    }

    @Nullable
    public final Integer sliceId() {
        return this.sliceId;
    }

    @Nullable
    public final String task() {
        return this.task;
    }

    @Nullable
    public final Long throttledMillis() {
        return this.throttledMillis;
    }

    @Nullable
    public final Long throttledUntilMillis() {
        return this.throttledUntilMillis;
    }

    @Nullable
    public final Boolean timedOut() {
        return this.timedOut;
    }

    @Nullable
    public final Long took() {
        return this.took;
    }

    @Nullable
    public final Long total() {
        return this.total;
    }

    @Nullable
    public final Long versionConflicts() {
        return this.versionConflicts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.batches != null) {
            generator.writeKey("batches");
            generator.write(this.batches.longValue());
        }
        if (this.deleted != null) {
            generator.writeKey("deleted");
            generator.write(this.deleted.longValue());
        }
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (BulkIndexByScrollFailure item0 : this.failures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.noops != null) {
            generator.writeKey("noops");
            generator.write(this.noops.longValue());
        }
        if (this.requestsPerSecond != null) {
            generator.writeKey("requests_per_second");
            generator.write((double)this.requestsPerSecond.floatValue());
        }
        if (this.retries != null) {
            generator.writeKey("retries");
            this.retries.serialize(generator, mapper);
        }
        if (this.sliceId != null) {
            generator.writeKey("slice_id");
            generator.write(this.sliceId.intValue());
        }
        if (this.task != null) {
            generator.writeKey("task");
            generator.write(this.task);
        }
        if (this.throttledMillis != null) {
            generator.writeKey("throttled_millis");
            generator.write(this.throttledMillis.longValue());
        }
        if (this.throttledUntilMillis != null) {
            generator.writeKey("throttled_until_millis");
            generator.write(this.throttledUntilMillis.longValue());
        }
        if (this.timedOut != null) {
            generator.writeKey("timed_out");
            generator.write(this.timedOut.booleanValue());
        }
        if (this.took != null) {
            generator.writeKey("took");
            generator.write(this.took.longValue());
        }
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total.longValue());
        }
        if (this.versionConflicts != null) {
            generator.writeKey("version_conflicts");
            generator.write(this.versionConflicts.longValue());
        }
    }

    protected static void setupDeleteByQueryResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::batches, JsonpDeserializer.longDeserializer(), "batches");
        op.add(Builder::deleted, JsonpDeserializer.longDeserializer(), "deleted");
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(BulkIndexByScrollFailure._DESERIALIZER), "failures");
        op.add(Builder::noops, JsonpDeserializer.longDeserializer(), "noops");
        op.add(Builder::requestsPerSecond, JsonpDeserializer.floatDeserializer(), "requests_per_second");
        op.add(Builder::retries, Retries._DESERIALIZER, "retries");
        op.add(Builder::sliceId, JsonpDeserializer.integerDeserializer(), "slice_id");
        op.add(Builder::task, JsonpDeserializer.stringDeserializer(), "task");
        op.add(Builder::throttledMillis, JsonpDeserializer.longDeserializer(), "throttled_millis");
        op.add(Builder::throttledUntilMillis, JsonpDeserializer.longDeserializer(), "throttled_until_millis");
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::versionConflicts, JsonpDeserializer.longDeserializer(), "version_conflicts");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DeleteByQueryResponse> {
        @Nullable
        private Long batches;
        @Nullable
        private Long deleted;
        @Nullable
        private List<BulkIndexByScrollFailure> failures;
        @Nullable
        private Long noops;
        @Nullable
        private Float requestsPerSecond;
        @Nullable
        private Retries retries;
        @Nullable
        private Integer sliceId;
        @Nullable
        private String task;
        @Nullable
        private Long throttledMillis;
        @Nullable
        private Long throttledUntilMillis;
        @Nullable
        private Boolean timedOut;
        @Nullable
        private Long took;
        @Nullable
        private Long total;
        @Nullable
        private Long versionConflicts;

        public final Builder batches(@Nullable Long value) {
            this.batches = value;
            return this;
        }

        public final Builder deleted(@Nullable Long value) {
            this.deleted = value;
            return this;
        }

        public final Builder failures(List<BulkIndexByScrollFailure> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        public final Builder failures(BulkIndexByScrollFailure value, BulkIndexByScrollFailure ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        public final Builder failures(Function<BulkIndexByScrollFailure.Builder, ObjectBuilder<BulkIndexByScrollFailure>> fn) {
            return this.failures(fn.apply(new BulkIndexByScrollFailure.Builder()).build(), new BulkIndexByScrollFailure[0]);
        }

        public final Builder noops(@Nullable Long value) {
            this.noops = value;
            return this;
        }

        public final Builder requestsPerSecond(@Nullable Float value) {
            this.requestsPerSecond = value;
            return this;
        }

        public final Builder retries(@Nullable Retries value) {
            this.retries = value;
            return this;
        }

        public final Builder retries(Function<Retries.Builder, ObjectBuilder<Retries>> fn) {
            return this.retries(fn.apply(new Retries.Builder()).build());
        }

        public final Builder sliceId(@Nullable Integer value) {
            this.sliceId = value;
            return this;
        }

        public final Builder task(@Nullable String value) {
            this.task = value;
            return this;
        }

        public final Builder throttledMillis(@Nullable Long value) {
            this.throttledMillis = value;
            return this;
        }

        public final Builder throttledUntilMillis(@Nullable Long value) {
            this.throttledUntilMillis = value;
            return this;
        }

        public final Builder timedOut(@Nullable Boolean value) {
            this.timedOut = value;
            return this;
        }

        public final Builder took(@Nullable Long value) {
            this.took = value;
            return this;
        }

        public final Builder total(@Nullable Long value) {
            this.total = value;
            return this;
        }

        public final Builder versionConflicts(@Nullable Long value) {
            this.versionConflicts = value;
            return this;
        }

        @Override
        public DeleteByQueryResponse build() {
            this._checkSingleUse();
            return new DeleteByQueryResponse(this);
        }
    }
}

