/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.remote_info;

import co.elastic.clients.elasticsearch.cluster.remote_info.ClusterRemoteInfoVariant;
import co.elastic.clients.elasticsearch.cluster.remote_info.ClusterRemoteProxyInfo;
import co.elastic.clients.elasticsearch.cluster.remote_info.ClusterRemoteSniffInfo;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ClusterRemoteInfo
implements TaggedUnion<Kind, ClusterRemoteInfoVariant>,
JsonpSerializable {
    private final Kind _kind;
    private final ClusterRemoteInfoVariant _value;
    public static final JsonpDeserializer<ClusterRemoteInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterRemoteInfo::setupClusterRemoteInfoDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final ClusterRemoteInfoVariant _get() {
        return this._value;
    }

    public ClusterRemoteInfo(ClusterRemoteInfoVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._clusterRemoteInfoKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private ClusterRemoteInfo(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static ClusterRemoteInfo of(Function<Builder, ObjectBuilder<ClusterRemoteInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isProxy() {
        return this._kind == Kind.Proxy;
    }

    public ClusterRemoteProxyInfo proxy() {
        return (ClusterRemoteProxyInfo)TaggedUnionUtils.get(this, Kind.Proxy);
    }

    public boolean isSniff() {
        return this._kind == Kind.Sniff;
    }

    public ClusterRemoteSniffInfo sniff() {
        return (ClusterRemoteSniffInfo)TaggedUnionUtils.get(this, Kind.Sniff);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    protected static void setupClusterRemoteInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::proxy, ClusterRemoteProxyInfo._DESERIALIZER, "proxy");
        op.add(Builder::sniff, ClusterRemoteSniffInfo._DESERIALIZER, "sniff");
        op.setTypeProperty("mode", null);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterRemoteInfo> {
        private Kind _kind;
        private ClusterRemoteInfoVariant _value;

        public ObjectBuilder<ClusterRemoteInfo> proxy(ClusterRemoteProxyInfo v) {
            this._kind = Kind.Proxy;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ClusterRemoteInfo> proxy(Function<ClusterRemoteProxyInfo.Builder, ObjectBuilder<ClusterRemoteProxyInfo>> fn) {
            return this.proxy(fn.apply(new ClusterRemoteProxyInfo.Builder()).build());
        }

        public ObjectBuilder<ClusterRemoteInfo> sniff(ClusterRemoteSniffInfo v) {
            this._kind = Kind.Sniff;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ClusterRemoteInfo> sniff(Function<ClusterRemoteSniffInfo.Builder, ObjectBuilder<ClusterRemoteSniffInfo>> fn) {
            return this.sniff(fn.apply(new ClusterRemoteSniffInfo.Builder()).build());
        }

        @Override
        public ClusterRemoteInfo build() {
            this._checkSingleUse();
            return new ClusterRemoteInfo(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Proxy("proxy"),
        Sniff("sniff");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

