/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.coordination;

import java.util.function.Function;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.partition.LeaderPartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.partition.SaasSourcePartition;

public class PartitionFactory
implements Function<SourcePartitionStoreItem, EnhancedSourcePartition> {
    @Override
    public EnhancedSourcePartition apply(SourcePartitionStoreItem partitionStoreItem) {
        String sourceIdentifier = partitionStoreItem.getSourceIdentifier();
        String partitionType = sourceIdentifier.substring(sourceIdentifier.lastIndexOf(124) + 1);
        if ("LEADER".equals(partitionType)) {
            return new LeaderPartition(partitionStoreItem);
        }
        if ("SAAS-WORKER".equals(partitionType)) {
            return new SaasSourcePartition(partitionStoreItem);
        }
        throw new RuntimeException(String.format("Unable to acquire other partition : %s. Probably we will introduce Global state in the future but for now, we don't expect to reach here.", partitionType));
    }
}

