/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.auth;

import java.time.Duration;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

public interface AuthenticationInterface {
    public static final Logger log = LoggerFactory.getLogger(AuthenticationInterface.class);

    default public Duration getRetryInterval() {
        return Duration.ofMinutes(10L);
    }

    default public void initCredentials() {
        log.info("Initializing credentials.");
        while (!this.isCredentialsInitialized()) {
            try {
                this.renewCredentials();
                this.setCredentialsInitialized(true);
                log.info("Credentials initialized successfully");
                break;
            }
            catch (SecurityException | HttpClientErrorException | HttpServerErrorException ex) {
                log.error(DataPrepperMarkers.NOISY, "Failed to initialize credentials, retrying in {} min. Reason for failure: {}", (Object)this.getRetryInterval().toMinutes(), (Object)ex.getMessage());
            }
            catch (Exception ex) {
                log.error(DataPrepperMarkers.NOISY, "Failed to initialize credentials due to unexpected error, retrying in {} min. Reason for failure:", (Object)this.getRetryInterval().toMinutes(), (Object)ex);
            }
            try {
                Thread.sleep(this.getRetryInterval().toMillis());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Credential initialization interrupted", ie);
            }
        }
    }

    public void renewCredentials();

    public boolean isCredentialsInitialized();

    public void setCredentialsInitialized(boolean var1);
}

