/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.dataprepper.expression.ParseTreeCompositeException;
import org.opensearch.dataprepper.expression.Parser;
import org.opensearch.dataprepper.expression.ParserErrorListener;
import org.opensearch.dataprepper.expression.antlr.DataPrepperExpressionParser;
import org.springframework.context.annotation.Scope;

@Named(value="singleThreadParser")
@Scope(value="prototype")
class ParseTreeParser
implements Parser<ParseTree> {
    static final String SINGLE_THREAD_PARSER_NAME = "singleThreadParser";
    private static final String MISSING_PARSER_ERROR_LISTENER_MESSAGE = "Expected DataPrepperExpressionParser to have error listener of type ParserErrorListener but none were found.";
    private final Map<String, ParseTree> cache = new HashMap<String, ParseTree>();
    private final ParserErrorListener errorListener;
    private final Lexer lexer;
    private final DataPrepperExpressionParser parser;

    @Inject
    public ParseTreeParser(DataPrepperExpressionParser parser) {
        this.parser = parser;
        this.errorListener = (ParserErrorListener)this.parser.getErrorListeners().stream().filter(errorListener -> errorListener instanceof ParserErrorListener).findFirst().orElseThrow(() -> new IllegalStateException(MISSING_PARSER_ERROR_LISTENER_MESSAGE));
        TokenSource tokenSource = parser.getTokenStream().getTokenSource();
        if (!(tokenSource instanceof Lexer)) {
            throw new ClassCastException("Expected DataPrepperStatementParser token source to be instance of Lexer");
        }
        this.lexer = (Lexer)tokenSource;
    }

    private ParseTree createParseTree(String expression) throws ParseTreeCompositeException {
        this.errorListener.resetErrors();
        CodePointCharStream input = CharStreams.fromString((String)expression);
        this.lexer.setInputStream((IntStream)input);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)this.lexer);
        this.parser.setTokenStream((TokenStream)tokenStream);
        DataPrepperExpressionParser.ExpressionContext parseTree = this.parser.expression();
        if (this.errorListener.isErrorFound()) {
            throw new ParseTreeCompositeException(this.errorListener.getExceptions());
        }
        return parseTree;
    }

    @Override
    public ParseTree parse(String expression) throws ParseTreeCompositeException {
        if (this.cache.containsKey(expression)) {
            return this.cache.get(expression);
        }
        ParseTree parseTree = this.createParseTree(expression);
        this.cache.put(expression, parseTree);
        return parseTree;
    }
}

