/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.opensearch.dataprepper.expression.ExpressionCoercionException;
import org.opensearch.dataprepper.expression.ExpressionFunctionProvider;
import org.opensearch.dataprepper.expression.antlr.DataPrepperExpressionParser;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyFactory;

@Named
class ParseTreeCoercionService {
    private static final Pattern QUOTE_PATTERN = Pattern.compile("^\"{1,3}|\"{1,3}$");
    private static final Pattern ARGUMENT_SPLITTER = Pattern.compile("(?<!\\\\),");
    private static final int INITIAL_ARG_LIST_SIZE = 8;
    private static final String INVALID_FUNCTION_FORMAT_OPEN = "Invalid function format: missing opening parenthesis";
    private static final String INVALID_FUNCTION_FORMAT_CLOSE = "Invalid function format: missing closing parenthesis";
    private static final String INVALID_STRING_ARG = "Invalid string argument: check if any argument is missing a closing double quote or contains comma that's not escaped with `\\`.";
    private static final String UNSUPPORTED_ARG_TYPE = "Unsupported type passed as function argument";
    private final Map<Class<? extends Serializable>, Function<Object, Object>> literalTypeConversions;
    private final ExpressionFunctionProvider expressionFunctionProvider;
    private final Function<Object, Object> convertLiteralType;
    private final ConcurrentMap<String, FunctionMetadata> cachedFunctionStrings = new ConcurrentHashMap<String, FunctionMetadata>(16, 0.75f);
    private final EventKeyFactory eventKeyFactory;

    public Object coercePrimaryTerminalNode(TerminalNode node, Event event) {
        Objects.requireNonNull(node, "TerminalNode cannot be null");
        int nodeType = node.getSymbol().getType();
        String nodeStringValue = node.getText();
        switch (nodeType) {
            case 1: {
                FunctionMetadata functionMetadata = this.cachedFunctionStrings.computeIfAbsent(nodeStringValue, this::parseFunctionMetadata);
                return this.expressionFunctionProvider.provideFunction(functionMetadata.functionName, functionMetadata.argList, event, this.convertLiteralType);
            }
            case 7: {
                return this.resolveJsonPointerValue(nodeStringValue.substring(1, nodeStringValue.length() - 1), event);
            }
            case 6: {
                return this.resolveJsonPointerValue(nodeStringValue, event);
            }
            case 9: {
                return QUOTE_PATTERN.matcher(nodeStringValue).replaceAll("");
            }
            case 2: {
                try {
                    return Integer.valueOf(nodeStringValue);
                }
                catch (NumberFormatException e) {
                    return Long.valueOf(nodeStringValue);
                }
            }
            case 3: {
                return Float.valueOf(nodeStringValue);
            }
            case 4: {
                return Boolean.valueOf(nodeStringValue);
            }
            case 13: {
                return 13;
            }
            case 11: {
                return 11;
            }
            case 5: {
                return null;
            }
            case 10: {
                return nodeStringValue;
            }
        }
        throw new ExpressionCoercionException("Unsupported terminal node type symbol string: " + DataPrepperExpressionParser.VOCABULARY.getDisplayName(nodeType));
    }

    @Inject
    public ParseTreeCoercionService(Map<Class<? extends Serializable>, Function<Object, Object>> literalTypeConversions, ExpressionFunctionProvider expressionFunctionProvider, EventKeyFactory eventKeyFactory) {
        Objects.requireNonNull(literalTypeConversions, "literalTypeConversions cannot be null");
        Objects.requireNonNull(expressionFunctionProvider, "expressionFunctionProvider cannot be null");
        this.literalTypeConversions = literalTypeConversions;
        this.convertLiteralType = value -> {
            if (literalTypeConversions.containsKey(value.getClass())) {
                return ((Function)literalTypeConversions.get(value.getClass())).apply(value);
            }
            throw new ExpressionCoercionException("Unsupported type for value " + String.valueOf(value));
        };
        this.expressionFunctionProvider = expressionFunctionProvider;
        this.eventKeyFactory = eventKeyFactory;
    }

    public <T> T coerce(Object obj, Class<T> clazz) throws ExpressionCoercionException {
        if (obj.getClass().isAssignableFrom(clazz)) {
            return (T)obj;
        }
        throw new ExpressionCoercionException("Unable to cast " + obj.getClass().getName() + " into " + clazz.getName());
    }

    private FunctionMetadata parseFunctionMetadata(String nodeStringValue) {
        int funcNameIndex = nodeStringValue.indexOf("(");
        if (funcNameIndex == -1) {
            throw new ExpressionCoercionException(INVALID_FUNCTION_FORMAT_OPEN);
        }
        String functionName = nodeStringValue.substring(0, funcNameIndex);
        int argsEndIndex = nodeStringValue.indexOf(")", funcNameIndex);
        if (argsEndIndex == -1) {
            throw new ExpressionCoercionException(INVALID_FUNCTION_FORMAT_CLOSE);
        }
        ArrayList<Object> argList = new ArrayList<Object>(8);
        if (argsEndIndex > funcNameIndex + 1) {
            String[] args;
            String argsStr = nodeStringValue.substring(funcNameIndex + 1, argsEndIndex);
            for (String arg : args = ARGUMENT_SPLITTER.split(argsStr)) {
                String trimmedArg = arg.trim();
                if (trimmedArg.isEmpty()) continue;
                if (trimmedArg.charAt(0) == '/') {
                    argList.add(trimmedArg);
                    continue;
                }
                if (trimmedArg.charAt(0) == '\"') {
                    if (trimmedArg.length() < 2 || trimmedArg.charAt(trimmedArg.length() - 1) != '\"') {
                        throw new ExpressionCoercionException(INVALID_STRING_ARG);
                    }
                    argList.add(trimmedArg);
                    continue;
                }
                throw new ExpressionCoercionException(UNSUPPORTED_ARG_TYPE);
            }
        }
        return new FunctionMetadata(functionName, argList);
    }

    private Object resolveJsonPointerValue(String jsonPointer, Event event) {
        EventKey eventKey = this.eventKeyFactory.createEventKey(jsonPointer);
        Object value = event.get(eventKey, Object.class);
        return value != null ? this.convertLiteralType.apply(value) : null;
    }

    private static final class FunctionMetadata {
        final String functionName;
        final List<Object> argList;

        private FunctionMetadata(String functionName, List<Object> argList) {
            this.functionName = functionName.intern();
            this.argList = argList;
        }
    }
}

