/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.loggenerator;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.source.loggenerator.LogGeneratorSourceConfig;
import org.opensearch.dataprepper.plugins.source.loggenerator.LogTypeGenerator;

@DataPrepperPlugin(name="log_generator", pluginType=Source.class, pluginConfigurationType=LogGeneratorSourceConfig.class)
public class LogGeneratorSource
implements Source<Record<Event>> {
    private final LogGeneratorSourceConfig sourceConfig;
    private final LogTypeGenerator logTypeGenerator;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AtomicBoolean stopGenerating = new AtomicBoolean();
    private final AtomicInteger logsGenerated = new AtomicInteger();

    @DataPrepperPluginConstructor
    public LogGeneratorSource(LogGeneratorSourceConfig sourceConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory) {
        this.sourceConfig = sourceConfig;
        this.logTypeGenerator = this.loadLogTypeGenerator(pluginFactory);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    private LogTypeGenerator loadLogTypeGenerator(PluginFactory pluginFactory) {
        PluginModel logTypeConfiguration = this.sourceConfig.getLogType();
        PluginSetting logTypePluginSetting = new PluginSetting(logTypeConfiguration.getPluginName(), logTypeConfiguration.getPluginSettings());
        return (LogTypeGenerator)pluginFactory.loadPlugin(LogTypeGenerator.class, logTypePluginSetting, new Object[0]);
    }

    public void start(Buffer<Record<Event>> buffer) {
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            if (!this.stopGenerating.get() && this.hasNotReachedLogCount()) {
                try {
                    Event generatedEvent = this.logTypeGenerator.generateEvent();
                    buffer.write(new Record((Object)generatedEvent), 500);
                    this.logsGenerated.getAndIncrement();
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        }, 0L, this.sourceConfig.getInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.stopGenerating.set(true);
        this.scheduledExecutorService.shutdown();
        try {
            if (!this.scheduledExecutorService.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                this.scheduledExecutorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduledExecutorService.shutdownNow();
        }
    }

    private boolean hasNotReachedLogCount() {
        if (this.sourceConfig.getCount() == 0) {
            return true;
        }
        return this.logsGenerated.get() < this.sourceConfig.getCount();
    }
}

