/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.loggenerator;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;

public class ApacheLogFaker {
    private static final String APACHE_EXTENDED_LOG_FORMAT = "%s %s %s [%s] \"%s %s HTTP/1.0\" %s %s \"http://%s\" \"%s\"";
    private static final String APACHE_COMMON_LOG_FORMAT = "%s %s %s [%s] \"%s %s HTTP/1.0\" %s %s";
    private static final String VALID_PASSWORD_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final String[] NAMES = new String[]{"rasul", "danny", "juste", "volodislavu", "reilly", "stas", "agapetus", "dev", "kornelie", "mats", "komang", "mandla", "samuil", "eastmund", "mathias", "sion", "margarita", "amata", "klavs", "jude"};
    private static final String[] URLS = new String[]{"amazon.com", "opensearch.org", "github.com", "wikipedia.com"};
    private static final String[] USER_AGENTS = new String[]{"Mozilla/4.0 (compatible; MSIE 6.0; AOL 9.0; Windows NT 5.1)", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36"};
    private static final String[] HTTP_METHODS = new String[]{"GET", "POST", "DELETE", "PUT"};
    private static final String[] FAKE_URIS = new String[]{"/list", "/explore", "/search/tag/list", "/apps/cart.jsp?appID="};
    private static final String[] FAKE_STATUS = new String[]{"200", "404", "500", "301"};
    private final Random random = new Random();
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MMM/y:HH:mm:ss Z");
    private final String[] passwords = this.randomPasswordArray(20, 8);

    private String[] randomPasswordArray(int passwordCount, int passwordSize) {
        String[] randomPasswords = new String[passwordCount];
        for (int i = 0; i < passwordCount; ++i) {
            randomPasswords[i] = "";
            for (int n = 0; n < passwordSize; ++n) {
                int n2 = i;
                randomPasswords[n2] = randomPasswords[n2] + VALID_PASSWORD_CHARACTERS.charAt(this.random.nextInt(VALID_PASSWORD_CHARACTERS.length()));
            }
        }
        return randomPasswords;
    }

    private String randomIpV4Address() {
        return this.random.nextInt(255) + "." + this.random.nextInt(255) + "." + this.random.nextInt(255) + "." + this.random.nextInt(255);
    }

    private String getRandomIn(String[] array) {
        return array[this.random.nextInt(array.length)];
    }

    private String randomDate() {
        Duration offset = Duration.ZERO.plusSeconds(this.random.nextInt(60)).plusMinutes(this.random.nextInt(60)).plusHours(this.random.nextInt(24)).plusDays(this.random.nextInt(365));
        return ZonedDateTime.now().minus(offset).format(this.dateTimeFormatter);
    }

    public String generateRandomExtendedApacheLog() {
        int bytes = this.random.nextInt(1001) + 4000;
        return String.format(APACHE_EXTENDED_LOG_FORMAT, this.randomIpV4Address(), this.getRandomIn(NAMES), this.getRandomIn(this.passwords), this.randomDate(), this.getRandomIn(HTTP_METHODS), this.getRandomIn(FAKE_URIS), this.getRandomIn(FAKE_STATUS), bytes, this.getRandomIn(URLS), this.getRandomIn(USER_AGENTS));
    }

    public String generateRandomCommonApacheLog() {
        int bytes = this.random.nextInt(1001) + 4000;
        return String.format(APACHE_COMMON_LOG_FORMAT, this.randomIpV4Address(), this.getRandomIn(NAMES), this.getRandomIn(this.passwords), this.randomDate(), this.getRandomIn(HTTP_METHODS), this.getRandomIn(FAKE_URIS), this.getRandomIn(FAKE_STATUS), bytes);
    }
}

