/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.mutateevent.SelectEntriesProcessorConfig;

@DataPrepperPlugin(name="select_entries", pluginType=Processor.class, pluginConfigurationType=SelectEntriesProcessorConfig.class)
public class SelectEntriesProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private final List<String> keysToInclude;
    private final List<Pattern> includeKeysRegex;
    private final String includeKeysRegexPointer;
    private final String selectWhen;
    private final ExpressionEvaluator expressionEvaluator;

    @DataPrepperPluginConstructor
    public SelectEntriesProcessor(PluginMetrics pluginMetrics, SelectEntriesProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.selectWhen = config.getSelectWhen();
        if (this.selectWhen != null && !expressionEvaluator.isValidExpressionStatement(this.selectWhen).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("select_when value of %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax.", this.selectWhen));
        }
        this.keysToInclude = config.getIncludeKeys();
        this.includeKeysRegex = config.getIncludeKeysRegex();
        this.includeKeysRegexPointer = config.getIncludeKeysRegexPointer();
        this.expressionEvaluator = expressionEvaluator;
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            if (Objects.nonNull(this.selectWhen) && !this.expressionEvaluator.evaluateConditional(this.selectWhen, recordEvent).booleanValue()) continue;
            Map<String, Object> outMap = this.getIncludeKeysOutputMap(recordEvent);
            Map<String, Object> regexOutMap = this.getIncludeKeysRegexOutputMap(recordEvent);
            recordEvent.clear();
            for (Map.Entry<String, Object> entry : outMap.entrySet()) {
                recordEvent.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : regexOutMap.entrySet()) {
                recordEvent.put(entry.getKey(), entry.getValue());
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }

    private Map<String, Object> getIncludeKeysOutputMap(Event event) {
        HashMap<String, Object> outMap = new HashMap<String, Object>();
        if (this.keysToInclude != null) {
            for (String keyToInclude : this.keysToInclude) {
                Object value = event.get(keyToInclude, Object.class);
                if (value == null) continue;
                outMap.put(keyToInclude, value);
            }
        }
        return outMap;
    }

    private Map<String, Object> getIncludeKeysRegexOutputMap(Event event) {
        Map eventMap;
        if (this.includeKeysRegex == null || this.includeKeysRegex.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        if (this.includeKeysRegexPointer != null && !this.includeKeysRegexPointer.equals("/")) {
            if (!event.containsKey(this.includeKeysRegexPointer)) {
                return Collections.emptyMap();
            }
            eventMap = (Map)event.get(this.includeKeysRegexPointer, Map.class);
        } else {
            eventMap = event.toMap();
        }
        block0: for (Map.Entry entry : eventMap.entrySet()) {
            if (this.keysToInclude != null && this.keysToInclude.contains(entry.getKey())) continue;
            for (Pattern includeKeyRegex : this.includeKeysRegex) {
                if (!includeKeyRegex.matcher((CharSequence)entry.getKey()).matches()) continue;
                String fullKey = this.getFullKey((String)entry.getKey(), this.includeKeysRegexPointer);
                outputMap.put(fullKey, entry.getValue());
                continue block0;
            }
        }
        return outputMap;
    }

    private String getFullKey(String key, String includeKeysRegexPointer) {
        return includeKeysRegexPointer != null ? includeKeysRegexPointer + "/" + key : key;
    }
}

