/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension;

import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opensearch.dataprepper.plugins.geoip.extension.GeoIPDatabaseManager;
import org.opensearch.dataprepper.plugins.geoip.extension.GeoIPProcessorService;
import org.opensearch.dataprepper.plugins.geoip.extension.GeoIpServiceConfig;
import org.opensearch.dataprepper.plugins.geoip.extension.api.GeoIpConfigSupplier;

class DefaultGeoIpConfigSupplier
implements GeoIpConfigSupplier {
    private final GeoIpServiceConfig geoIpServiceConfig;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final GeoIPDatabaseManager geoIPDatabaseManager;

    public DefaultGeoIpConfigSupplier(GeoIpServiceConfig geoIpServiceConfig, GeoIPDatabaseManager geoIPDatabaseManager, ReentrantReadWriteLock.ReadLock readLock) {
        this.geoIpServiceConfig = geoIpServiceConfig;
        this.geoIPDatabaseManager = geoIPDatabaseManager;
        this.readLock = readLock;
    }

    @Override
    public Optional<GeoIPProcessorService> getGeoIPProcessorService() {
        if (this.geoIpServiceConfig != null) {
            return Optional.of(new GeoIPProcessorService(this.geoIpServiceConfig, this.geoIPDatabaseManager, this.readLock));
        }
        return Optional.empty();
    }
}

