/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.dynamicconfiguration;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.state.RandomCutForestMapper;
import com.amazon.randomcutforest.testutils.NormalMixtureTestData;

public class DynamicSampling
implements Example {
    public static void main(String[] args) throws Exception {
        new DynamicSampling().run();
    }

    @Override
    public String command() {
        return "dynamic_sampling";
    }

    @Override
    public String description() {
        return "check dynamic sampling";
    }

    @Override
    public void run() throws Exception {
        int dimensions = 4;
        int numberOfTrees = 50;
        int sampleSize = 256;
        Precision precision = Precision.FLOAT_64;
        int dataSize = 4 * sampleSize;
        NormalMixtureTestData testData = new NormalMixtureTestData();
        RandomCutForest forest = RandomCutForest.builder().compact(true).dimensions(dimensions).randomSeed(0L).numberOfTrees(numberOfTrees).sampleSize(sampleSize).precision(precision).build();
        RandomCutForest forest2 = RandomCutForest.builder().compact(true).dimensions(dimensions).randomSeed(0L).numberOfTrees(numberOfTrees).sampleSize(sampleSize).precision(precision).build();
        int first_anomalies = 0;
        int second_anomalies = 0;
        forest2.setTimeDecay(10.0 * forest2.getTimeDecay());
        for (double[] point : testData.generateTestData(dataSize, dimensions)) {
            if (forest.getAnomalyScore(point) > 1.0) {
                ++first_anomalies;
            }
            if (forest2.getAnomalyScore(point) > 1.0) {
                ++second_anomalies;
            }
            forest.update(point);
            forest2.update(point);
        }
        System.out.println("Unusual scores: forest one " + first_anomalies + ", second one " + second_anomalies);
        second_anomalies = 0;
        first_anomalies = 0;
        testData = new NormalMixtureTestData(-3.0, 40.0);
        for (double[] point : testData.generateTestData(dataSize, dimensions)) {
            if (forest.getAnomalyScore(point) > 1.0) {
                ++first_anomalies;
            }
            if (forest2.getAnomalyScore(point) > 1.0) {
                ++second_anomalies;
            }
            forest.update(point);
            forest2.update(point);
        }
        System.out.println("Unusual scores: forest one " + first_anomalies + ", second one " + second_anomalies);
        second_anomalies = 0;
        first_anomalies = 0;
        RandomCutForestMapper mapper = new RandomCutForestMapper();
        mapper.setSaveExecutorContextEnabled(true);
        RandomCutForest copyForest = mapper.toModel(mapper.toState(forest));
        copyForest.setTimeDecay(50.0 * forest.getTimeDecay());
        testData = new NormalMixtureTestData(-10.0, -40.0);
        int forced_change_anomalies = 0;
        for (double[] point : testData.generateTestData(dataSize, dimensions)) {
            if (forest.getAnomalyScore(point) > 1.0) {
                ++first_anomalies;
            }
            if (forest2.getAnomalyScore(point) > 1.0) {
                ++second_anomalies;
            }
            if (copyForest.getAnomalyScore(point) > 1.0) {
                ++forced_change_anomalies;
            }
            copyForest.update(point);
            forest.update(point);
            forest2.update(point);
        }
        System.out.println("Unusual scores: forest one " + first_anomalies + ", second one " + second_anomalies + ", forced (first) " + forced_change_anomalies);
    }
}

