/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples;

import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.examples.dynamicinference.DynamicDensity;
import com.amazon.randomcutforest.examples.dynamicinference.DynamicNearNeighbor;
import com.amazon.randomcutforest.examples.serialization.JsonExample;
import com.amazon.randomcutforest.examples.serialization.ProtostuffExample;
import java.util.Map;
import java.util.TreeMap;

public class Main {
    public static final String ARCHIVE_NAME = "randomcutforest-examples-1.0.jar";
    private final Map<String, Example> examples = new TreeMap<String, Example>();
    private int maxCommandLength = 0;

    public static void main(String[] args) throws Exception {
        new Main().run(args);
    }

    public Main() {
        this.add(new JsonExample());
        this.add(new ProtostuffExample());
        this.add(new DynamicDensity());
        this.add(new DynamicNearNeighbor());
    }

    private void add(Example example) {
        this.examples.put(example.command(), example);
        if (this.maxCommandLength < example.command().length()) {
            this.maxCommandLength = example.command().length();
        }
    }

    public void run(String[] args) throws Exception {
        if (args == null || args.length < 1 || args[0].equals("-h") || args[0].equals("--help")) {
            this.printUsage();
            return;
        }
        String command = args[0];
        if (!this.examples.containsKey(command)) {
            throw new IllegalArgumentException("No such example: " + command);
        }
        this.examples.get(command).run();
    }

    public void printUsage() {
        System.out.printf("Usage: java -cp %s [example]%n", ARCHIVE_NAME);
        System.out.println("Examples:");
        String formatString = String.format("\t %%%ds - %%s%%n", this.maxCommandLength);
        for (Example example : this.examples.values()) {
            System.out.printf(formatString, example.command(), example.description());
        }
    }
}

