/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseWithReferenceRequest<T>
extends BaseRequest<T> {
    public BaseWithReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions, @Nonnull Class<T> entityClass) {
        super(requestUrl, client, requestOptions, entityClass);
    }

    @Nonnull
    public CompletableFuture<T> postAsync(@Nullable T newEntity, @Nonnull IJsonBackedObject payload) {
        Objects.requireNonNull(payload, "parameter payload cannot be null");
        return this.sendAsync(HttpMethod.POST, payload);
    }

    @Nullable
    public T post(@Nullable T newEntity, @Nonnull IJsonBackedObject payload) throws ClientException {
        Objects.requireNonNull(payload, "parameter payload cannot be null");
        Object response = this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newEntity;
        }
        return null;
    }

    @Nonnull
    public CompletableFuture<T> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public T get() throws ClientException {
        return this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<T> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<T> patchAsync(@Nonnull T sourceObject) {
        Objects.requireNonNull(sourceObject, "parameter sourceObject cannot be null");
        return this.sendAsync(HttpMethod.PATCH, sourceObject);
    }

    @Nullable
    public T patch(@Nonnull T sourceObject) throws ClientException {
        Objects.requireNonNull(sourceObject, "parameter sourceObject cannot be null");
        return this.send(HttpMethod.PATCH, sourceObject);
    }
}

