/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.anomalydetector;

import io.micrometer.core.instrument.Counter;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.hasher.IdentificationKeysHasher;
import org.opensearch.dataprepper.plugins.processor.anomalydetector.AnomalyDetectorMode;
import org.opensearch.dataprepper.plugins.processor.anomalydetector.AnomalyDetectorProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="anomaly_detector", pluginType=Processor.class, pluginConfigurationType=AnomalyDetectorProcessorConfig.class)
public class AnomalyDetectorProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    public static final String DEVIATION_KEY = "deviation_from_expected";
    public static final String GRADE_KEY = "grade";
    static final String NUMBER_RCF_INSTANCES = "RCFInstances";
    static final String CARDINALITY_OVERFLOW = "cardinalityOverflow";
    private final Boolean verbose;
    private final int cardinalityLimit;
    private final IdentificationKeysHasher identificationKeysHasher;
    private final List<String> keys;
    private final PluginFactory pluginFactory;
    private final HashMap<Integer, AnomalyDetectorMode> forestMap;
    private final AtomicInteger cardinality;
    private final AnomalyDetectorProcessorConfig anomalyDetectorProcessorConfig;
    private static final Logger LOG = LoggerFactory.getLogger(AnomalyDetectorProcessor.class);
    private final Counter cardinalityOverflowCounter;
    Instant nextWarnTime = Instant.MIN;

    @DataPrepperPluginConstructor
    public AnomalyDetectorProcessor(AnomalyDetectorProcessorConfig anomalyDetectorProcessorConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory) {
        super(pluginMetrics);
        this.identificationKeysHasher = new IdentificationKeysHasher(anomalyDetectorProcessorConfig.getIdentificationKeys());
        this.anomalyDetectorProcessorConfig = anomalyDetectorProcessorConfig;
        this.pluginFactory = pluginFactory;
        this.keys = anomalyDetectorProcessorConfig.getKeys();
        this.verbose = anomalyDetectorProcessorConfig.getVerbose();
        this.cardinality = (AtomicInteger)pluginMetrics.gauge(NUMBER_RCF_INSTANCES, (Number)new AtomicInteger());
        this.cardinalityLimit = anomalyDetectorProcessorConfig.getCardinalityLimit();
        this.cardinalityOverflowCounter = pluginMetrics.counter(CARDINALITY_OVERFLOW);
        this.forestMap = new HashMap();
    }

    private AnomalyDetectorMode loadAnomalyDetectorMode(PluginFactory pluginFactory) {
        PluginModel modeConfiguration = this.anomalyDetectorProcessorConfig.getDetectorMode();
        PluginSetting modePluginSetting = new PluginSetting(modeConfiguration.getPluginName(), modeConfiguration.getPluginSettings());
        return (AnomalyDetectorMode)pluginFactory.loadPlugin(AnomalyDetectorMode.class, modePluginSetting, new Object[0]);
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        LinkedList<Record<Event>> recordsOut = new LinkedList<Record<Event>>();
        for (Record<Event> record : records) {
            Event event = (Event)record.getData();
            IdentificationKeysHasher.IdentificationKeysMap identificationKeysMap = this.identificationKeysHasher.createIdentificationKeysMapFromEvent(event);
            AnomalyDetectorMode forest = this.forestMap.get(identificationKeysMap.hashCode());
            if (Objects.nonNull(forest)) {
                recordsOut.addAll(forest.handleEvents(List.of(record)));
                continue;
            }
            if (this.forestMap.size() < this.cardinalityLimit) {
                forest = this.loadAnomalyDetectorMode(this.pluginFactory);
                forest.initialize(this.keys, this.verbose);
                this.forestMap.put(identificationKeysMap.hashCode(), forest);
                recordsOut.addAll(forest.handleEvents(List.of(record)));
                continue;
            }
            if (Instant.now().isAfter(this.nextWarnTime)) {
                LOG.warn("Cardinality limit reached, see cardinalityOverflow metric for count of skipped records");
                this.nextWarnTime = Instant.now().plus(5L, ChronoUnit.MINUTES);
            }
            this.cardinalityOverflowCounter.increment();
        }
        this.cardinality.set(this.forestMap.size());
        return recordsOut;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

