/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core;

import org.opensearch.dataprepper.core.DataPrepperArgs;
import org.opensearch.dataprepper.core.parser.config.DataPrepperAppConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
class DataPrepperArgumentConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DataPrepperAppConfiguration.class);
    private static final String COMMAND_LINE_ARG_DELIMITER = ",";

    DataPrepperArgumentConfiguration() {
    }

    @Bean
    public DataPrepperArgs dataPrepperArgs(Environment environment) {
        String commandLineArgs = environment.getProperty("nonOptionArgs");
        LOG.info("Command line args: {}", (Object)commandLineArgs);
        if (commandLineArgs != null) {
            String[] args = commandLineArgs.split(COMMAND_LINE_ARG_DELIMITER);
            return new DataPrepperArgs(args);
        }
        throw new RuntimeException("Configuration file command line argument required but none found");
    }
}

