/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.opensearch.dataprepper.core.parser.config.FileStructurePathProvider;
import org.opensearch.dataprepper.logstash.LogstashConfigConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataPrepperArgs
implements FileStructurePathProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DataPrepperArgs.class);
    private static final Integer DATA_PREPPER_PIPELINE_CONFIG_POSITON = 0;
    private static final Integer DATA_PREPPER_CONFIG_POSITON = 1;
    private static final Integer MAXIMUM_SUPPORTED_NUMBER_OF_ARGS = 2;
    private final String pipelineConfigFileLocation;
    private final String dataPrepperConfigFileLocation;

    private static String checkForLogstashConfigurationAndConvert(String configurationFileLocation) {
        File configurationLocationAsFile = new File(configurationFileLocation);
        LogstashConfigConverter logstashConfigConverter = new LogstashConfigConverter();
        if (configurationLocationAsFile.isDirectory()) {
            Path configurationDirectory = Paths.get(configurationFileLocation, new String[0]).toAbsolutePath();
            FileFilter confFilter = pathname -> pathname.getName().endsWith(".conf");
            for (File file : configurationLocationAsFile.listFiles(confFilter)) {
                LOG.info("Detected logstash configuration file {}, attempting to convert to Data Prepper pipeline", (Object)file.getName());
                try {
                    logstashConfigConverter.convertLogstashConfigurationToPipeline(file.getAbsolutePath(), String.valueOf(configurationDirectory));
                }
                catch (IOException e) {
                    LOG.warn("Unable to read the Logstash configuration file", (Throwable)e);
                    throw new IllegalArgumentException("Invalid Logstash configuration file", e);
                }
            }
        } else if (configurationFileLocation.endsWith(".conf")) {
            LOG.debug("Detected logstash configuration file, attempting to convert to Data Prepper pipeline");
            Path configurationDirectory = Paths.get(configurationFileLocation, new String[0]).toAbsolutePath().getParent();
            try {
                configurationFileLocation = logstashConfigConverter.convertLogstashConfigurationToPipeline(configurationFileLocation, String.valueOf(configurationDirectory));
            }
            catch (IOException e) {
                LOG.warn("Unable to read the Logstash configuration file", (Throwable)e);
                throw new IllegalArgumentException("Invalid Logstash configuration file", e);
            }
        }
        return configurationFileLocation;
    }

    public DataPrepperArgs(String ... args) {
        if (args == null || args.length == 0) {
            this.invalidArgumentsReceived("Configuration file command line argument required but none found");
        } else if (args.length > MAXIMUM_SUPPORTED_NUMBER_OF_ARGS) {
            this.invalidArgumentsReceived("Data Prepper supports a maximum of " + MAXIMUM_SUPPORTED_NUMBER_OF_ARGS + " command line arguments");
        }
        String configurationFileLocation = args[DATA_PREPPER_PIPELINE_CONFIG_POSITON];
        LOG.info("Using {} configuration file", (Object)configurationFileLocation);
        this.pipelineConfigFileLocation = DataPrepperArgs.checkForLogstashConfigurationAndConvert(configurationFileLocation);
        this.dataPrepperConfigFileLocation = args.length > DATA_PREPPER_CONFIG_POSITON ? args[DATA_PREPPER_CONFIG_POSITON] : null;
    }

    private void invalidArgumentsReceived(String msg) {
        LOG.warn("Invalid Data Prepper arguments received. Valid argument format: <pipeline-config-file-path> [<data-prepper-config-file-path>]");
        throw new IllegalArgumentException(msg);
    }

    public String getPipelineConfigFileLocation() {
        return this.pipelineConfigFileLocation;
    }

    @Nullable
    public String getDataPrepperConfigFileLocation() {
        return this.dataPrepperConfigFileLocation;
    }
}

