/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingConfigurationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingConfigurationInfo> {
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinCapacity").getter(ScalingConfigurationInfo.getter(ScalingConfigurationInfo::minCapacity)).setter(ScalingConfigurationInfo.setter(Builder::minCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacity").getter(ScalingConfigurationInfo.getter(ScalingConfigurationInfo::maxCapacity)).setter(ScalingConfigurationInfo.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<Boolean> AUTO_PAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoPause").getter(ScalingConfigurationInfo.getter(ScalingConfigurationInfo::autoPause)).setter(ScalingConfigurationInfo.setter(Builder::autoPause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPause").build()}).build();
    private static final SdkField<Integer> SECONDS_UNTIL_AUTO_PAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SecondsUntilAutoPause").getter(ScalingConfigurationInfo.getter(ScalingConfigurationInfo::secondsUntilAutoPause)).setter(ScalingConfigurationInfo.setter(Builder::secondsUntilAutoPause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsUntilAutoPause").build()}).build();
    private static final SdkField<String> TIMEOUT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeoutAction").getter(ScalingConfigurationInfo.getter(ScalingConfigurationInfo::timeoutAction)).setter(ScalingConfigurationInfo.setter(Builder::timeoutAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutAction").build()}).build();
    private static final SdkField<Integer> SECONDS_BEFORE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SecondsBeforeTimeout").getter(ScalingConfigurationInfo.getter(ScalingConfigurationInfo::secondsBeforeTimeout)).setter(ScalingConfigurationInfo.setter(Builder::secondsBeforeTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsBeforeTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD, MAX_CAPACITY_FIELD, AUTO_PAUSE_FIELD, SECONDS_UNTIL_AUTO_PAUSE_FIELD, TIMEOUT_ACTION_FIELD, SECONDS_BEFORE_TIMEOUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScalingConfigurationInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer minCapacity;
    private final Integer maxCapacity;
    private final Boolean autoPause;
    private final Integer secondsUntilAutoPause;
    private final String timeoutAction;
    private final Integer secondsBeforeTimeout;

    private ScalingConfigurationInfo(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.autoPause = builder.autoPause;
        this.secondsUntilAutoPause = builder.secondsUntilAutoPause;
        this.timeoutAction = builder.timeoutAction;
        this.secondsBeforeTimeout = builder.secondsBeforeTimeout;
    }

    public final Integer minCapacity() {
        return this.minCapacity;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final Boolean autoPause() {
        return this.autoPause;
    }

    public final Integer secondsUntilAutoPause() {
        return this.secondsUntilAutoPause;
    }

    public final String timeoutAction() {
        return this.timeoutAction;
    }

    public final Integer secondsBeforeTimeout() {
        return this.secondsBeforeTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoPause());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondsUntilAutoPause());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondsBeforeTimeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConfigurationInfo)) {
            return false;
        }
        ScalingConfigurationInfo other = (ScalingConfigurationInfo)obj;
        return Objects.equals(this.minCapacity(), other.minCapacity()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.autoPause(), other.autoPause()) && Objects.equals(this.secondsUntilAutoPause(), other.secondsUntilAutoPause()) && Objects.equals(this.timeoutAction(), other.timeoutAction()) && Objects.equals(this.secondsBeforeTimeout(), other.secondsBeforeTimeout());
    }

    public final String toString() {
        return ToString.builder((String)"ScalingConfigurationInfo").add("MinCapacity", (Object)this.minCapacity()).add("MaxCapacity", (Object)this.maxCapacity()).add("AutoPause", (Object)this.autoPause()).add("SecondsUntilAutoPause", (Object)this.secondsUntilAutoPause()).add("TimeoutAction", (Object)this.timeoutAction()).add("SecondsBeforeTimeout", (Object)this.secondsBeforeTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinCapacity": {
                return Optional.ofNullable(clazz.cast(this.minCapacity()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "AutoPause": {
                return Optional.ofNullable(clazz.cast(this.autoPause()));
            }
            case "SecondsUntilAutoPause": {
                return Optional.ofNullable(clazz.cast(this.secondsUntilAutoPause()));
            }
            case "TimeoutAction": {
                return Optional.ofNullable(clazz.cast(this.timeoutAction()));
            }
            case "SecondsBeforeTimeout": {
                return Optional.ofNullable(clazz.cast(this.secondsBeforeTimeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MinCapacity", MIN_CAPACITY_FIELD);
        map.put("MaxCapacity", MAX_CAPACITY_FIELD);
        map.put("AutoPause", AUTO_PAUSE_FIELD);
        map.put("SecondsUntilAutoPause", SECONDS_UNTIL_AUTO_PAUSE_FIELD);
        map.put("TimeoutAction", TIMEOUT_ACTION_FIELD);
        map.put("SecondsBeforeTimeout", SECONDS_BEFORE_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScalingConfigurationInfo, T> g) {
        return obj -> g.apply((ScalingConfigurationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minCapacity;
        private Integer maxCapacity;
        private Boolean autoPause;
        private Integer secondsUntilAutoPause;
        private String timeoutAction;
        private Integer secondsBeforeTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingConfigurationInfo model) {
            this.minCapacity(model.minCapacity);
            this.maxCapacity(model.maxCapacity);
            this.autoPause(model.autoPause);
            this.secondsUntilAutoPause(model.secondsUntilAutoPause);
            this.timeoutAction(model.timeoutAction);
            this.secondsBeforeTimeout(model.secondsBeforeTimeout);
        }

        public final Integer getMinCapacity() {
            return this.minCapacity;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Boolean getAutoPause() {
            return this.autoPause;
        }

        public final void setAutoPause(Boolean autoPause) {
            this.autoPause = autoPause;
        }

        @Override
        public final Builder autoPause(Boolean autoPause) {
            this.autoPause = autoPause;
            return this;
        }

        public final Integer getSecondsUntilAutoPause() {
            return this.secondsUntilAutoPause;
        }

        public final void setSecondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
        }

        @Override
        public final Builder secondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
            return this;
        }

        public final String getTimeoutAction() {
            return this.timeoutAction;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        @Override
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        public final Integer getSecondsBeforeTimeout() {
            return this.secondsBeforeTimeout;
        }

        public final void setSecondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
        }

        @Override
        public final Builder secondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
            return this;
        }

        public ScalingConfigurationInfo build() {
            return new ScalingConfigurationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingConfigurationInfo> {
        public Builder minCapacity(Integer var1);

        public Builder maxCapacity(Integer var1);

        public Builder autoPause(Boolean var1);

        public Builder secondsUntilAutoPause(Integer var1);

        public Builder timeoutAction(String var1);

        public Builder secondsBeforeTimeout(Integer var1);
    }
}

