/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.OptionConfiguration;
import software.amazon.awssdk.services.rds.model.OptionConfigurationListCopier;
import software.amazon.awssdk.services.rds.model.OptionNamesListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyOptionGroupRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyOptionGroupRequest> {
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(ModifyOptionGroupRequest.getter(ModifyOptionGroupRequest::optionGroupName)).setter(ModifyOptionGroupRequest.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<List<OptionConfiguration>> OPTIONS_TO_INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptionsToInclude").getter(ModifyOptionGroupRequest.getter(ModifyOptionGroupRequest::optionsToInclude)).setter(ModifyOptionGroupRequest.setter(Builder::optionsToInclude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionsToInclude").build(), ListTrait.builder().memberLocationName("OptionConfiguration").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionConfiguration").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OPTIONS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptionsToRemove").getter(ModifyOptionGroupRequest.getter(ModifyOptionGroupRequest::optionsToRemove)).setter(ModifyOptionGroupRequest.setter(Builder::optionsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApplyImmediately").getter(ModifyOptionGroupRequest.getter(ModifyOptionGroupRequest::applyImmediately)).setter(ModifyOptionGroupRequest.setter(Builder::applyImmediately)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_GROUP_NAME_FIELD, OPTIONS_TO_INCLUDE_FIELD, OPTIONS_TO_REMOVE_FIELD, APPLY_IMMEDIATELY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyOptionGroupRequest.memberNameToFieldInitializer();
    private final String optionGroupName;
    private final List<OptionConfiguration> optionsToInclude;
    private final List<String> optionsToRemove;
    private final Boolean applyImmediately;

    private ModifyOptionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.optionGroupName = builder.optionGroupName;
        this.optionsToInclude = builder.optionsToInclude;
        this.optionsToRemove = builder.optionsToRemove;
        this.applyImmediately = builder.applyImmediately;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    public final boolean hasOptionsToInclude() {
        return this.optionsToInclude != null && !(this.optionsToInclude instanceof SdkAutoConstructList);
    }

    public final List<OptionConfiguration> optionsToInclude() {
        return this.optionsToInclude;
    }

    public final boolean hasOptionsToRemove() {
        return this.optionsToRemove != null && !(this.optionsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> optionsToRemove() {
        return this.optionsToRemove;
    }

    public final Boolean applyImmediately() {
        return this.applyImmediately;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionsToInclude() ? this.optionsToInclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionsToRemove() ? this.optionsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyOptionGroupRequest)) {
            return false;
        }
        ModifyOptionGroupRequest other = (ModifyOptionGroupRequest)((Object)obj);
        return Objects.equals(this.optionGroupName(), other.optionGroupName()) && this.hasOptionsToInclude() == other.hasOptionsToInclude() && Objects.equals(this.optionsToInclude(), other.optionsToInclude()) && this.hasOptionsToRemove() == other.hasOptionsToRemove() && Objects.equals(this.optionsToRemove(), other.optionsToRemove()) && Objects.equals(this.applyImmediately(), other.applyImmediately());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyOptionGroupRequest").add("OptionGroupName", (Object)this.optionGroupName()).add("OptionsToInclude", this.hasOptionsToInclude() ? this.optionsToInclude() : null).add("OptionsToRemove", this.hasOptionsToRemove() ? this.optionsToRemove() : null).add("ApplyImmediately", (Object)this.applyImmediately()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "OptionsToInclude": {
                return Optional.ofNullable(clazz.cast(this.optionsToInclude()));
            }
            case "OptionsToRemove": {
                return Optional.ofNullable(clazz.cast(this.optionsToRemove()));
            }
            case "ApplyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OptionGroupName", OPTION_GROUP_NAME_FIELD);
        map.put("OptionsToInclude", OPTIONS_TO_INCLUDE_FIELD);
        map.put("OptionsToRemove", OPTIONS_TO_REMOVE_FIELD);
        map.put("ApplyImmediately", APPLY_IMMEDIATELY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyOptionGroupRequest, T> g) {
        return obj -> g.apply((ModifyOptionGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String optionGroupName;
        private List<OptionConfiguration> optionsToInclude = DefaultSdkAutoConstructList.getInstance();
        private List<String> optionsToRemove = DefaultSdkAutoConstructList.getInstance();
        private Boolean applyImmediately;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyOptionGroupRequest model) {
            super(model);
            this.optionGroupName(model.optionGroupName);
            this.optionsToInclude(model.optionsToInclude);
            this.optionsToRemove(model.optionsToRemove);
            this.applyImmediately(model.applyImmediately);
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final List<OptionConfiguration.Builder> getOptionsToInclude() {
            List<OptionConfiguration.Builder> result = OptionConfigurationListCopier.copyToBuilder(this.optionsToInclude);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionsToInclude(Collection<OptionConfiguration.BuilderImpl> optionsToInclude) {
            this.optionsToInclude = OptionConfigurationListCopier.copyFromBuilder(optionsToInclude);
        }

        @Override
        public final Builder optionsToInclude(Collection<OptionConfiguration> optionsToInclude) {
            this.optionsToInclude = OptionConfigurationListCopier.copy(optionsToInclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToInclude(OptionConfiguration ... optionsToInclude) {
            this.optionsToInclude(Arrays.asList(optionsToInclude));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToInclude(Consumer<OptionConfiguration.Builder> ... optionsToInclude) {
            this.optionsToInclude(Stream.of(optionsToInclude).map(c -> (OptionConfiguration)((OptionConfiguration.Builder)OptionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getOptionsToRemove() {
            if (this.optionsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.optionsToRemove;
        }

        public final void setOptionsToRemove(Collection<String> optionsToRemove) {
            this.optionsToRemove = OptionNamesListCopier.copy(optionsToRemove);
        }

        @Override
        public final Builder optionsToRemove(Collection<String> optionsToRemove) {
            this.optionsToRemove = OptionNamesListCopier.copy(optionsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToRemove(String ... optionsToRemove) {
            this.optionsToRemove(Arrays.asList(optionsToRemove));
            return this;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyOptionGroupRequest build() {
            return new ModifyOptionGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyOptionGroupRequest> {
        public Builder optionGroupName(String var1);

        public Builder optionsToInclude(Collection<OptionConfiguration> var1);

        public Builder optionsToInclude(OptionConfiguration ... var1);

        public Builder optionsToInclude(Consumer<OptionConfiguration.Builder> ... var1);

        public Builder optionsToRemove(Collection<String> var1);

        public Builder optionsToRemove(String ... var1);

        public Builder applyImmediately(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

