/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.services.rds.model.SourceRegion;
import software.amazon.awssdk.services.rds.model.SourceRegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSourceRegionsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeSourceRegionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeSourceRegionsResponse.getter(DescribeSourceRegionsResponse::marker)).setter(DescribeSourceRegionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<SourceRegion>> SOURCE_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceRegions").getter(DescribeSourceRegionsResponse.getter(DescribeSourceRegionsResponse::sourceRegions)).setter(DescribeSourceRegionsResponse.setter(Builder::sourceRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegions").build(), ListTrait.builder().memberLocationName("SourceRegion").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, SOURCE_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSourceRegionsResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<SourceRegion> sourceRegions;

    private DescribeSourceRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.sourceRegions = builder.sourceRegions;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasSourceRegions() {
        return this.sourceRegions != null && !(this.sourceRegions instanceof SdkAutoConstructList);
    }

    public final List<SourceRegion> sourceRegions() {
        return this.sourceRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceRegions() ? this.sourceRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSourceRegionsResponse)) {
            return false;
        }
        DescribeSourceRegionsResponse other = (DescribeSourceRegionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasSourceRegions() == other.hasSourceRegions() && Objects.equals(this.sourceRegions(), other.sourceRegions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSourceRegionsResponse").add("Marker", (Object)this.marker()).add("SourceRegions", this.hasSourceRegions() ? this.sourceRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "SourceRegions": {
                return Optional.ofNullable(clazz.cast(this.sourceRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("SourceRegions", SOURCE_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSourceRegionsResponse, T> g) {
        return obj -> g.apply((DescribeSourceRegionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<SourceRegion> sourceRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSourceRegionsResponse model) {
            super(model);
            this.marker(model.marker);
            this.sourceRegions(model.sourceRegions);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<SourceRegion.Builder> getSourceRegions() {
            List<SourceRegion.Builder> result = SourceRegionListCopier.copyToBuilder(this.sourceRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceRegions(Collection<SourceRegion.BuilderImpl> sourceRegions) {
            this.sourceRegions = SourceRegionListCopier.copyFromBuilder(sourceRegions);
        }

        @Override
        public final Builder sourceRegions(Collection<SourceRegion> sourceRegions) {
            this.sourceRegions = SourceRegionListCopier.copy(sourceRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRegions(SourceRegion ... sourceRegions) {
            this.sourceRegions(Arrays.asList(sourceRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRegions(Consumer<SourceRegion.Builder> ... sourceRegions) {
            this.sourceRegions(Stream.of(sourceRegions).map(c -> (SourceRegion)((SourceRegion.Builder)SourceRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeSourceRegionsResponse build() {
            return new DescribeSourceRegionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSourceRegionsResponse> {
        public Builder marker(String var1);

        public Builder sourceRegions(Collection<SourceRegion> var1);

        public Builder sourceRegions(SourceRegion ... var1);

        public Builder sourceRegions(Consumer<SourceRegion.Builder> ... var1);
    }
}

