/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws;

import java.util.Optional;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.aws.CredentialsCache;
import org.opensearch.dataprepper.plugins.aws.CredentialsProviderFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

class DefaultAwsCredentialsSupplier
implements AwsCredentialsSupplier {
    private final CredentialsProviderFactory credentialsProviderFactory;
    private final CredentialsCache credentialsCache;

    DefaultAwsCredentialsSupplier(CredentialsProviderFactory credentialsProviderFactory, CredentialsCache credentialsCache) {
        this.credentialsProviderFactory = credentialsProviderFactory;
        this.credentialsCache = credentialsCache;
    }

    public AwsCredentialsProvider getProvider(AwsCredentialsOptions options) {
        return this.credentialsCache.getOrCreate(options, () -> this.credentialsProviderFactory.providerFromOptions(options));
    }

    public Optional<Region> getDefaultRegion() {
        return Optional.ofNullable(this.credentialsProviderFactory.getDefaultRegion());
    }

    public Optional<String> getDefaultStsRoleArn() {
        return Optional.ofNullable(this.credentialsProviderFactory.getDefaultStsRoleArn());
    }
}

