/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.plugins.aws.AwsStsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.EqualJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

class CredentialsProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialsProviderFactory.class);
    private static final String AWS_IAM = "iam";
    private static final String AWS_IAM_ROLE = "role";
    static final int STS_CLIENT_RETRIES = 10;
    static final long STS_CLIENT_BASE_BACKOFF_MILLIS = 1000L;
    static final long STS_CLIENT_MAX_BACKOFF_MILLIS = 60000L;
    private final AwsStsConfiguration defaultStsConfiguration;

    public CredentialsProviderFactory(AwsStsConfiguration defaultStsConfiguration) {
        Objects.requireNonNull(defaultStsConfiguration);
        this.defaultStsConfiguration = defaultStsConfiguration;
    }

    Region getDefaultRegion() {
        return this.defaultStsConfiguration.getAwsRegion();
    }

    String getDefaultStsRoleArn() {
        return this.defaultStsConfiguration.getAwsStsRoleArn();
    }

    AwsCredentialsProvider providerFromOptions(AwsCredentialsOptions credentialsOptions) {
        Objects.requireNonNull(credentialsOptions);
        if (credentialsOptions.isUseDefaultCredentialsProvider()) {
            return DefaultCredentialsProvider.create();
        }
        if (credentialsOptions.getStsRoleArn() != null || this.defaultStsConfiguration.getAwsStsRoleArn() != null) {
            return this.createStsCredentials(credentialsOptions);
        }
        return DefaultCredentialsProvider.create();
    }

    private AwsCredentialsProvider createStsCredentials(AwsCredentialsOptions credentialsOptions) {
        Map<String, String> awsStsHeaderOverrides;
        boolean useDefaultStsRoleArn;
        String stsRoleArn;
        if (credentialsOptions.getStsRoleArn() != null) {
            stsRoleArn = credentialsOptions.getStsRoleArn();
            useDefaultStsRoleArn = false;
        } else {
            stsRoleArn = this.defaultStsConfiguration.getAwsStsRoleArn();
            useDefaultStsRoleArn = true;
        }
        this.validateStsRoleArn(stsRoleArn);
        LOG.debug("Creating new AwsCredentialsProvider with role {}.", (Object)stsRoleArn);
        Region region = this.defaultStsConfiguration.getAwsRegion() != null ? this.defaultStsConfiguration.getAwsRegion() : credentialsOptions.getRegion();
        StsClient stsClient = this.createStsClient(region);
        AssumeRoleRequest.Builder assumeRoleRequestBuilder = AssumeRoleRequest.builder().roleSessionName("Data-Prepper-" + String.valueOf(UUID.randomUUID())).roleArn(stsRoleArn);
        if (credentialsOptions.getStsExternalId() != null && !credentialsOptions.getStsExternalId().isEmpty()) {
            assumeRoleRequestBuilder = assumeRoleRequestBuilder.externalId(credentialsOptions.getStsExternalId());
        }
        if ((awsStsHeaderOverrides = useDefaultStsRoleArn ? this.defaultStsConfiguration.getStsHeaderOverrides() : credentialsOptions.getStsHeaderOverrides()) != null && !awsStsHeaderOverrides.isEmpty()) {
            assumeRoleRequestBuilder = assumeRoleRequestBuilder.overrideConfiguration(configuration -> awsStsHeaderOverrides.forEach((arg_0, arg_1) -> ((AwsRequestOverrideConfiguration.Builder)configuration).putHeader(arg_0, arg_1)));
        }
        return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)assumeRoleRequestBuilder.build()).build();
    }

    private void validateStsRoleArn(String stsRoleArn) {
        Arn arn = this.getArn(stsRoleArn);
        if (!AWS_IAM.equals(arn.service())) {
            throw new IllegalArgumentException("sts_role_arn must be an IAM Role");
        }
        Optional resourceType = arn.resource().resourceType();
        if (resourceType.isEmpty() || !((String)resourceType.get()).equals(AWS_IAM_ROLE)) {
            throw new IllegalArgumentException("sts_role_arn must be an IAM Role");
        }
    }

    private Arn getArn(String stsRoleArn) {
        try {
            return Arn.fromString((String)stsRoleArn);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid ARN format for awsStsRoleArn. Check the format of %s", stsRoleArn));
        }
    }

    protected StsClient createStsClient(Region region) {
        EqualJitterBackoffStrategy backoffStrategy = EqualJitterBackoffStrategy.builder().baseDelay(Duration.ofMillis(1000L)).maxBackoffTime(Duration.ofMillis(60000L)).build();
        RetryPolicy retryPolicy = RetryPolicy.builder().numRetries(Integer.valueOf(10)).retryCondition(RetryCondition.defaultRetryCondition()).backoffStrategy((BackoffStrategy)backoffStrategy).throttlingBackoffStrategy((BackoffStrategy)backoffStrategy).build();
        ClientOverrideConfiguration clientOverrideConfiguration = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(retryPolicy).build();
        StsClientBuilder stsClientBuilder = (StsClientBuilder)StsClient.builder().overrideConfiguration(clientOverrideConfiguration);
        stsClientBuilder = Optional.ofNullable(region).map(arg_0 -> ((StsClientBuilder)stsClientBuilder).region(arg_0)).orElse(stsClientBuilder);
        return (StsClient)stsClientBuilder.build();
    }
}

