/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import java.util.Map;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.PutSecretValueRequest;

public class AwsSecretManagerConfiguration {
    static final String DEFAULT_AWS_REGION = "us-east-1";
    @JsonProperty(value="secret_id")
    @NotNull
    @Size(min=1, max=512, message="awsSecretId length should be between 1 and 512 characters")
    private @NotNull @Size(min=1, max=512, message="awsSecretId length should be between 1 and 512 characters") String awsSecretId;
    @JsonProperty(value="region")
    @Size(min=1, message="Region cannot be empty string")
    private @Size(min=1, message="Region cannot be empty string") String awsRegion = "us-east-1";
    @JsonProperty(value="sts_role_arn")
    @Size(min=20, max=2048, message="awsStsRoleArn length should be between 1 and 2048 characters")
    private @Size(min=20, max=2048, message="awsStsRoleArn length should be between 1 and 2048 characters") String awsStsRoleArn;
    @JsonProperty(value="sts_header_overrides")
    @Size(max=5, message="sts_header_overrides supports a maximum of 5 headers to override")
    private @Size(max=5, message="sts_header_overrides supports a maximum of 5 headers to override") Map<String, String> awsStsHeaderOverrides;
    @JsonProperty(value="refresh_interval")
    @NotNull(message="refresh_interval must not be null")
    @DurationMin(hours=1L, message="Refresh interval must be at least 1 hour.")
    private @NotNull(message="refresh_interval must not be null") @DurationMin(hours=1L, message="Refresh interval must be at least 1 hour.") Duration refreshInterval = Duration.ofHours(1L);
    @JsonProperty(value="disable_refresh")
    private boolean disableRefresh = false;

    public String getAwsSecretId() {
        return this.awsSecretId;
    }

    public Region getAwsRegion() {
        return Region.of((String)this.awsRegion);
    }

    public Duration getRefreshInterval() {
        return this.refreshInterval;
    }

    public boolean isDisableRefresh() {
        return this.disableRefresh;
    }

    public SecretsManagerClient createSecretManagerClient(AwsCredentialsSupplier awsCredentialsSupplier) {
        AwsCredentialsProvider awsCredentialsProvider = awsCredentialsSupplier.getProvider(AwsCredentialsOptions.builder().withRegion(this.awsRegion).withStsRoleArn(this.awsStsRoleArn).withStsHeaderOverrides(this.awsStsHeaderOverrides).build());
        return (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().credentialsProvider(awsCredentialsProvider)).region(this.getAwsRegion())).build();
    }

    public GetSecretValueRequest createGetSecretValueRequest() {
        return (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(this.awsSecretId).build();
    }

    public PutSecretValueRequest putSecretValueRequest(String secretKeyValueMapAsString) {
        return (PutSecretValueRequest)PutSecretValueRequest.builder().secretId(this.awsSecretId).secretString(secretKeyValueMapAsString).build();
    }
}

