/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.processor;

import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Optional;

class GeoInetAddress {
    GeoInetAddress() {
    }

    static Optional<InetAddress> usableInetFromString(String ipAddress) {
        InetAddress address;
        try {
            address = InetAddresses.forString((String)ipAddress);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
        if (GeoInetAddress.isPublicIpAddress(address)) {
            return Optional.of(address);
        }
        return Optional.empty();
    }

    private static boolean isPublicIpAddress(InetAddress ipAddress) {
        if (ipAddress instanceof Inet6Address || ipAddress instanceof Inet4Address) {
            return !ipAddress.isSiteLocalAddress() && !ipAddress.isLoopbackAddress();
        }
        return false;
    }
}

