/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.EnterpriseResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.RepresentedCountry;
import com.maxmind.geoip2.record.Subdivision;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.dataprepper.plugins.geoip.GeoIPDatabase;
import org.opensearch.dataprepper.plugins.geoip.GeoIPField;
import org.opensearch.dataprepper.plugins.geoip.exception.DatabaseReaderInitializationException;
import org.opensearch.dataprepper.plugins.geoip.exception.EnrichFailedException;
import org.opensearch.dataprepper.plugins.geoip.exception.NoValidDatabaseFoundException;
import org.opensearch.dataprepper.plugins.geoip.extension.api.GeoIPDatabaseReader;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.DatabaseReaderBuilder;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.GeoIPFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeoIP2DatabaseReader
implements GeoIPDatabaseReader,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIP2DatabaseReader.class);
    private static final String MAXMIND_GEOIP2_DATABASE_TYPE = "geoip2";
    private final DatabaseReaderBuilder databaseReaderBuilder;
    private final String databasePath;
    private final int cacheSize;
    private final AtomicInteger closeCount;
    private final GeoIPFileManager geoIPFileManager;
    private final AtomicBoolean isEnterpriseDatabaseExpired;
    private DatabaseReader enterpriseDatabaseReader;
    private Instant enterpriseDatabaseBuildDate;

    public GeoIP2DatabaseReader(DatabaseReaderBuilder databaseReaderBuilder, GeoIPFileManager geoIPFileManager, String databasePath, int cacheSize) {
        this.databaseReaderBuilder = databaseReaderBuilder;
        this.geoIPFileManager = geoIPFileManager;
        this.databasePath = databasePath;
        this.cacheSize = cacheSize;
        this.closeCount = new AtomicInteger(1);
        this.isEnterpriseDatabaseExpired = new AtomicBoolean(false);
        this.buildDatabaseReaders();
    }

    private void buildDatabaseReaders() {
        try {
            Optional<String> enterpriseDatabaseName = this.getDatabaseName("geoip2-enterprise", this.databasePath, MAXMIND_GEOIP2_DATABASE_TYPE);
            if (enterpriseDatabaseName.isPresent()) {
                this.enterpriseDatabaseReader = this.databaseReaderBuilder.buildReader(Path.of(this.databasePath + File.separator + enterpriseDatabaseName.get(), new String[0]), this.cacheSize);
                this.enterpriseDatabaseBuildDate = this.enterpriseDatabaseReader.getMetadata().getBuildDate().toInstant();
            }
        }
        catch (IOException ex) {
            throw new DatabaseReaderInitializationException("Exception while creating GeoIP2 DatabaseReaders due to: " + ex.getMessage());
        }
        if (this.enterpriseDatabaseReader == null) {
            throw new NoValidDatabaseFoundException("Unable to initialize GeoIP2 database, make sure it is valid.");
        }
    }

    @Override
    public Map<String, Object> getGeoData(InetAddress inetAddress, Collection<GeoIPField> fields, Collection<GeoIPDatabase> geoIPDatabases) {
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        try {
            if (this.enterpriseDatabaseReader != null && !this.isEnterpriseDatabaseExpired.get() && geoIPDatabases.contains((Object)GeoIPDatabase.ENTERPRISE)) {
                Optional optionalEnterpriseResponse = this.enterpriseDatabaseReader.tryEnterprise(inetAddress);
                optionalEnterpriseResponse.ifPresent(response -> this.processEnterpriseResponse((EnterpriseResponse)response, (Map<String, Object>)geoData, fields));
            }
            if (this.enterpriseDatabaseReader != null && !this.isEnterpriseDatabaseExpired.get() && geoIPDatabases.contains((Object)GeoIPDatabase.ASN)) {
                Optional asnResponse = this.enterpriseDatabaseReader.tryAsn(inetAddress);
                asnResponse.ifPresent(response -> this.processAsnResponse((AsnResponse)response, (Map<String, Object>)geoData, fields));
            }
        }
        catch (GeoIp2Exception e) {
            throw new EnrichFailedException("Address not found in database.");
        }
        catch (IOException e) {
            throw new EnrichFailedException("Failed to close database readers gracefully. It can be due to expired databases");
        }
        return geoData;
    }

    private void processEnterpriseResponse(EnterpriseResponse enterpriseResponse, Map<String, Object> geoData, Collection<GeoIPField> fields) {
        Continent continent = enterpriseResponse.getContinent();
        Country country = enterpriseResponse.getCountry();
        Country registeredCountry = enterpriseResponse.getRegisteredCountry();
        RepresentedCountry representedCountry = enterpriseResponse.getRepresentedCountry();
        City city = enterpriseResponse.getCity();
        Location location = enterpriseResponse.getLocation();
        Postal postal = enterpriseResponse.getPostal();
        Subdivision mostSpecificSubdivision = enterpriseResponse.getMostSpecificSubdivision();
        Subdivision leastSpecificSubdivision = enterpriseResponse.getLeastSpecificSubdivision();
        this.extractContinentFields(continent, geoData, fields);
        this.extractCountryFields(country, geoData, fields, true);
        this.extractRegisteredCountryFields(registeredCountry, geoData, fields);
        this.extractRepresentedCountryFields(representedCountry, geoData, fields);
        this.extractCityFields(city, geoData, fields, true);
        this.extractLocationFields(location, geoData, fields);
        this.extractPostalFields(postal, geoData, fields, true);
        this.extractMostSpecifiedSubdivisionFields(mostSpecificSubdivision, geoData, fields, true);
        this.extractLeastSpecifiedSubdivisionFields(leastSpecificSubdivision, geoData, fields, true);
    }

    private void processAsnResponse(AsnResponse asnResponse, Map<String, Object> geoData, Collection<GeoIPField> fields) {
        this.extractAsnFields(asnResponse, geoData, fields);
    }

    @Override
    public boolean isExpired() {
        Instant instant = Instant.now();
        if (this.enterpriseDatabaseReader == null) {
            return true;
        }
        if (this.isEnterpriseDatabaseExpired.get()) {
            return true;
        }
        if (this.enterpriseDatabaseBuildDate.plus(MAX_EXPIRY_DURATION).isBefore(instant)) {
            this.isEnterpriseDatabaseExpired.set(true);
            this.closeReader();
        }
        return this.isEnterpriseDatabaseExpired.get();
    }

    @Override
    public void retain() {
    }

    @Override
    public void close() {
        this.closeReader();
    }

    private void closeReader() {
        try {
            if (this.enterpriseDatabaseReader != null) {
                this.enterpriseDatabaseReader.close();
            }
        }
        catch (IOException e) {
            LOG.debug("Failed to close Maxmind database readers due to: {}. Force closing readers.", (Object)e.getMessage());
        }
        File file = new File(this.databasePath);
        this.geoIPFileManager.deleteDirectory(file);
    }
}

