/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Size;
import java.util.Map;
import java.util.UUID;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AwsAuthenticationOptionsConfig {
    @JsonProperty(value="region")
    @Size(min=1, message="Region cannot be empty string")
    private @Size(min=1, message="Region cannot be empty string") String awsRegion;
    @JsonProperty(value="sts_role_arn")
    @Size(min=20, max=2048, message="awsStsRoleArn length should be between 1 and 2048 characters")
    private @Size(min=20, max=2048, message="awsStsRoleArn length should be between 1 and 2048 characters") String awsStsRoleArn;
    @JsonProperty(value="sts_header_overrides")
    @Size(max=5, message="sts_header_overrides supports a maximum of 5 headers to override")
    private @Size(max=5, message="sts_header_overrides supports a maximum of 5 headers to override") Map<String, String> awsStsHeaderOverrides;

    public Region getAwsRegion() {
        return this.awsRegion != null ? Region.of((String)this.awsRegion) : null;
    }

    public AwsCredentialsProvider authenticateAwsConfiguration() {
        DefaultCredentialsProvider awsCredentialsProvider;
        if (this.awsStsRoleArn != null && !this.awsStsRoleArn.isEmpty()) {
            try {
                Arn.fromString((String)this.awsStsRoleArn);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid ARN format for awsStsRoleArn");
            }
            StsClient stsClient = (StsClient)((StsClientBuilder)StsClient.builder().region(this.getAwsRegion())).build();
            AssumeRoleRequest.Builder assumeRoleRequestBuilder = AssumeRoleRequest.builder().roleSessionName("GeoIP-Processor-" + String.valueOf(UUID.randomUUID())).roleArn(this.awsStsRoleArn);
            if (this.awsStsHeaderOverrides != null && !this.awsStsHeaderOverrides.isEmpty()) {
                assumeRoleRequestBuilder = assumeRoleRequestBuilder.overrideConfiguration(configuration -> this.awsStsHeaderOverrides.forEach((arg_0, arg_1) -> ((AwsRequestOverrideConfiguration.Builder)configuration).putHeader(arg_0, arg_1)));
            }
            awsCredentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)assumeRoleRequestBuilder.build()).build();
        } else {
            awsCredentialsProvider = DefaultCredentialsProvider.create();
        }
        return awsCredentialsProvider;
    }
}

