/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.personalize;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.sink.personalize.configuration.PersonalizeSinkConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersonalizeSinkService {
    private static final Logger LOG = LoggerFactory.getLogger(PersonalizeSinkService.class);
    public static final String RECORDS_SUCCEEDED = "personalizeRecordsSucceeded";
    public static final String RECORDS_FAILED = "personalizeRecordsFailed";
    public static final String RECORDS_INVALID = "personalizeRecordsInvalid";
    public static final String REQUESTS_THROTTLED = "personalizeRequestsThrottled";
    public static final String REQUEST_LATENCY = "personalizeRequestLatency";
    private final PersonalizeSinkConfiguration personalizeSinkConfig;
    private final Lock reentrantLock;
    private final int maxRetries;
    private final Counter recordsSucceededCounter;
    private final Counter recordsFailedCounter;
    private final Counter recordsInvalidCounter;
    private final Counter requestsThrottledCounter;
    private final Timer requestLatencyTimer;

    public PersonalizeSinkService(PersonalizeSinkConfiguration personalizeSinkConfig, PluginMetrics pluginMetrics) {
        this.personalizeSinkConfig = personalizeSinkConfig;
        this.reentrantLock = new ReentrantLock();
        this.maxRetries = personalizeSinkConfig.getMaxRetries();
        this.recordsSucceededCounter = pluginMetrics.counter(RECORDS_SUCCEEDED);
        this.recordsFailedCounter = pluginMetrics.counter(RECORDS_FAILED);
        this.recordsInvalidCounter = pluginMetrics.counter(RECORDS_INVALID);
        this.requestsThrottledCounter = pluginMetrics.counter(REQUESTS_THROTTLED);
        this.requestLatencyTimer = pluginMetrics.timer(REQUEST_LATENCY);
    }

    void output(Collection<Record<Event>> records) {
        LOG.trace("{} records received", (Object)records.size());
    }
}

