/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.csv;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.ExampleValues;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>csv</code> processor parses comma-separated values (CSVs) strings into structured data.")
public class CsvProcessorConfig {
    static final String DEFAULT_SOURCE = "message";
    static final String DEFAULT_DELIMITER = ",";
    static final String DEFAULT_QUOTE_CHARACTER = "\"";
    static final Boolean DEFAULT_DELETE_HEADERS = true;
    @JsonProperty(value="source", defaultValue="message")
    @JsonPropertyDescription(value="The field in the event that will be parsed. Default value is <code>message</code>.")
    @NotBlank
    private String source = "message";
    @JsonProperty(value="delimiter", defaultValue=",")
    @JsonPropertyDescription(value="The character separating each column. Default value is <code>,</code>.")
    private String delimiter = ",";
    @JsonProperty(value="delete_header", defaultValue="true")
    @JsonPropertyDescription(value="If specified, the event header (<code>column_names_source_key</code>) is deleted after the event is parsed. If there is no event header, no action is taken. Default value is true.")
    private Boolean deleteHeader = DEFAULT_DELETE_HEADERS;
    @JsonProperty(value="normalize_keys", defaultValue="false")
    @JsonPropertyDescription(value="If set to true, replaces invalid characters with underscore character")
    private Boolean normalizeKeys = false;
    @JsonProperty(value="multiline", defaultValue="false")
    @JsonPropertyDescription(value="If specified, the source key has multiple lines, including header line")
    private Boolean multiLine = false;
    @JsonProperty(value="quote_character", defaultValue="\"")
    @JsonPropertyDescription(value="The character used as a text qualifier for a single column of data. Default value is <code>\"</code>.")
    private String quoteCharacter = "\"";
    @JsonProperty(value="column_names_source_key")
    @JsonPropertyDescription(value="The field in the event that specifies the CSV column names, which will be automatically detected. If there are additional columns in the <code>source</code>, the column names are automatically generated according to column index. If <code>column_names</code> is also defined, the header in <code>column_names_source_key</code> can also be used to generate the event fields. If too few columns are specified in this field, the remaining column names are automatically generated. If too many column names are specified in this field, the CSV processor omits the extra column names.")
    private String columnNamesSourceKey;
    @JsonProperty(value="column_names")
    @JsonPropertyDescription(value="User-specified names for the CSV columns. Default value is <code>[column1, column2, ..., columnN]</code> if there are no columns of data in the CSV record and <code>column_names_source_key</code> is not defined. If <code>column_names_source_key</code> is defined, the header in <code>column_names_source_key</code> generates the event fields. If too few columns are specified in this field, the remaining column names are automatically generated. If too many column names are specified in this field, the CSV processor omits the extra column names.")
    @ExampleValues(value={@ExampleValues.Example(value="column_one", description="Specifies column_one as one of the column names to create")})
    private List<String> columnNames;
    @JsonPropertyDescription(value="If true, the configured source field will be deleted after the CSV data is parsed into separate fields.")
    @JsonProperty
    private boolean deleteSource = false;
    @JsonProperty(value="csv_when")
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a> such as <code>/some_key == \"test\"</code>. If specified, the <code>csv</code> processor will only run on events when the expression evaluates to true. ")
    @ExampleValues(value={@ExampleValues.Example(value="/some_key == null", description="Only runs the csv processor if the key some_key is null or does not exist.")})
    private String csvWhen;

    public String getSource() {
        return this.source;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public Boolean isDeleteHeader() {
        return this.deleteHeader;
    }

    public String getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public String getColumnNamesSourceKey() {
        return this.columnNamesSourceKey;
    }

    public Boolean getNormalizeKeys() {
        return this.normalizeKeys;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public String getCsvWhen() {
        return this.csvWhen;
    }

    public Boolean isDeleteSource() {
        return this.deleteSource;
    }

    public Boolean isMultiLine() {
        return this.multiLine;
    }

    @AssertTrue(message="delimiter must be exactly one character.")
    @AssertTrue(message="delimiter must be exactly one character.") boolean isValidDelimiter() {
        return this.delimiter.length() == 1;
    }

    @AssertTrue(message="quote_character must be exactly one character.")
    @AssertTrue(message="quote_character must be exactly one character.") boolean isValidQuoteCharacter() {
        return this.quoteCharacter.length() == 1;
    }

    @AssertTrue(message="quote_character and delimiter cannot be the same character")
    @AssertTrue(message="quote_character and delimiter cannot be the same character") boolean areDelimiterAndQuoteCharacterDifferent() {
        return !this.delimiter.equals(this.quoteCharacter);
    }
}

