/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.csv;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import io.micrometer.core.instrument.Counter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.DefaultEventHandle;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.csv.CsvProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="csv", pluginType=Processor.class, pluginConfigurationType=CsvProcessorConfig.class)
public class CsvProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(CsvProcessor.class);
    static final String CSV_INVALID_EVENTS = "csvInvalidEvents";
    private final Counter csvInvalidEventsCounter;
    private final CsvProcessorConfig config;
    private final ExpressionEvaluator expressionEvaluator;
    private final CsvMapper mapper;
    private final CsvSchema schema;
    private final boolean normalizeKeys;

    @DataPrepperPluginConstructor
    public CsvProcessor(PluginMetrics pluginMetrics, CsvProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.csvInvalidEventsCounter = pluginMetrics.counter(CSV_INVALID_EVENTS);
        this.config = config;
        this.expressionEvaluator = expressionEvaluator;
        if (config.getCsvWhen() != null && !expressionEvaluator.isValidExpressionStatement(config.getCsvWhen()).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("csv_when value of %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax.", config.getCsvWhen()));
        }
        this.normalizeKeys = config.getNormalizeKeys();
        this.mapper = this.createCsvMapper();
        this.schema = this.createCsvSchema();
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        ArrayList<Record> recordsOut = new ArrayList<Record>();
        for (Record<Event> record : records) {
            Event event = (Event)record.getData();
            try {
                String message;
                if (this.config.getCsvWhen() != null && !this.expressionEvaluator.evaluateConditional(this.config.getCsvWhen(), event).booleanValue() || Objects.isNull(message = (String)event.get(this.config.getSource(), String.class))) continue;
                if (this.config.isMultiLine().booleanValue()) {
                    String[] lines = message.split("[\r\n]+");
                    if (lines.length <= 1) continue;
                    List<String> header = Arrays.asList(lines[0].split(this.config.getDelimiter().substring(0, 1)));
                    for (int i = 1; i < lines.length; ++i) {
                        MappingIterator messageIterator = this.mapper.readerFor(List.class).with((FormatSchema)this.schema).readValues(lines[i]);
                        if (!messageIterator.hasNextValue()) continue;
                        JacksonEvent clonedEvent = JacksonEvent.fromEvent((Event)event);
                        List row = (List)messageIterator.nextValue();
                        this.putDataInEvent((Event)clonedEvent, header, row);
                        this.addToAcknowledgementSetFromOriginEvent((Event)clonedEvent, event);
                        recordsOut.add(new Record((Object)clonedEvent));
                    }
                    continue;
                }
                boolean userDidSpecifyHeaderEventKey = Objects.nonNull(this.config.getColumnNamesSourceKey());
                boolean thisEventHasHeaderSource = userDidSpecifyHeaderEventKey && event.containsKey(this.config.getColumnNamesSourceKey());
                MappingIterator messageIterator = this.mapper.readerFor(List.class).with((FormatSchema)this.schema).readValues(message);
                if (messageIterator.hasNextValue()) {
                    List row = (List)messageIterator.nextValue();
                    List<String> header = this.parseHeader(event, thisEventHasHeaderSource, this.mapper, this.schema);
                    this.putDataInEvent(event, header, row);
                }
                if (thisEventHasHeaderSource && Boolean.TRUE.equals(this.config.isDeleteHeader())) {
                    event.delete(this.config.getColumnNamesSourceKey());
                }
                if (!this.config.isDeleteSource().booleanValue()) continue;
                event.delete(this.config.getSource());
            }
            catch (IOException e) {
                this.csvInvalidEventsCounter.increment();
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("An exception occurred while reading event [{}]").addArgument((Object)event).setCause((Throwable)e).log();
            }
        }
        return this.config.isMultiLine() != false ? recordsOut : records;
    }

    protected void addToAcknowledgementSetFromOriginEvent(Event recordEvent, Event originRecordEvent) {
        DefaultEventHandle eventHandle = (DefaultEventHandle)originRecordEvent.getEventHandle();
        if (eventHandle != null) {
            eventHandle.addEventHandle(recordEvent.getEventHandle());
        }
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }

    private CsvMapper createCsvMapper() {
        CsvMapper mapper = new CsvMapper();
        mapper.enable(CsvParser.Feature.WRAP_AS_ARRAY);
        return mapper;
    }

    private CsvSchema createCsvSchema() {
        char delimiterAsChar = this.config.getDelimiter().charAt(0);
        char quoteCharAsChar = this.config.getQuoteCharacter().charAt(0);
        CsvSchema schema = CsvSchema.emptySchema().withColumnSeparator(delimiterAsChar).withQuoteChar(quoteCharAsChar);
        return schema;
    }

    private List<String> parseHeader(Event event, boolean thisEventHasHeaderSource, CsvMapper mapper, CsvSchema schema) {
        if (thisEventHasHeaderSource) {
            return this.parseHeaderFromEventSourceKey(event, mapper, schema);
        }
        if (Objects.nonNull(this.config.getColumnNames())) {
            return this.config.getColumnNames();
        }
        ArrayList<String> emptyHeader = new ArrayList<String>();
        return emptyHeader;
    }

    private List<String> parseHeaderFromEventSourceKey(Event event, CsvMapper mapper, CsvSchema schema) {
        try {
            String headerUnprocessed = (String)event.get(this.config.getColumnNamesSourceKey(), String.class);
            MappingIterator headerIterator = mapper.readerFor(List.class).with((FormatSchema)schema).readValues(headerUnprocessed);
            List headerFromEventSource = (List)headerIterator.nextValue();
            return headerFromEventSource;
        }
        catch (IOException e) {
            LOG.debug("Auto generating header because of IOException on the header of event [{}]", (Object)event, (Object)e);
            ArrayList<String> emptyHeader = new ArrayList<String>();
            return emptyHeader;
        }
    }

    private void putDataInEvent(Event event, List<String> header, List<String> data) {
        for (int providedHeaderColIdx = 0; providedHeaderColIdx < header.size() && providedHeaderColIdx < data.size(); ++providedHeaderColIdx) {
            String key = header.get(providedHeaderColIdx);
            event.put(key, (Object)data.get(providedHeaderColIdx), this.normalizeKeys);
        }
        for (int remainingColIdx = providedHeaderColIdx; remainingColIdx < data.size(); ++remainingColIdx) {
            event.put(this.generateColumnHeader(remainingColIdx), (Object)data.get(remainingColIdx));
        }
    }

    private String generateColumnHeader(int colNumber) {
        int displayColNumber = colNumber + 1;
        return "column" + displayColNumber;
    }
}

