/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion.jsr310;

import com.amazon.ion.Timestamp;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.dataformat.ion.jsr310.TimestampUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.BiFunction;

public class IonTimestampInstantDeserializer<T extends Temporal>
extends StdScalarDeserializer<T>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    public static final IonTimestampInstantDeserializer<Instant> INSTANT = new IonTimestampInstantDeserializer<Instant>(Instant.class, (instant, zoneID) -> instant);
    public static final IonTimestampInstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new IonTimestampInstantDeserializer<OffsetDateTime>(OffsetDateTime.class, OffsetDateTime::ofInstant);
    public static final IonTimestampInstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new IonTimestampInstantDeserializer<ZonedDateTime>(ZonedDateTime.class, ZonedDateTime::ofInstant);
    protected final BiFunction<Instant, ZoneId, T> fromInstant;
    protected final Boolean adjustToContextTZOverride;

    protected IonTimestampInstantDeserializer(Class<T> vc, BiFunction<Instant, ZoneId, T> fromInstant) {
        super(vc);
        this.fromInstant = fromInstant;
        this.adjustToContextTZOverride = null;
    }

    protected IonTimestampInstantDeserializer(IonTimestampInstantDeserializer<T> base, Boolean adjustToContextTZOverride) {
        super(base.handledType());
        this.fromInstant = base.fromInstant;
        this.adjustToContextTZOverride = adjustToContextTZOverride;
    }

    public T deserialize(JsonParser p, DeserializationContext context) throws IOException, JsonProcessingException {
        ZoneId defaultZoneId = context.getTimeZone().toZoneId().normalized();
        switch (p.getCurrentToken()) {
            case VALUE_NUMBER_FLOAT: {
                return this.fromDecimal(p.getDecimalValue(), defaultZoneId);
            }
            case VALUE_NUMBER_INT: {
                return this.fromLong(p.getLongValue(), defaultZoneId, context);
            }
            case VALUE_EMBEDDED_OBJECT: {
                Object embeddedObject = p.getEmbeddedObject();
                if (!Timestamp.class.isAssignableFrom(embeddedObject.getClass())) break;
                return this.fromTimestamp((Timestamp)embeddedObject, defaultZoneId);
            }
        }
        try {
            return (T)((Temporal)context.handleUnexpectedToken(this._valueClass, p));
        }
        catch (JsonMappingException e) {
            throw e;
        }
        catch (IOException e) {
            throw JsonMappingException.fromUnexpectedIOE((IOException)e);
        }
    }

    public JsonDeserializer<T> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        if (format != null) {
            return new IonTimestampInstantDeserializer<T>(this, format.getFeature(JsonFormat.Feature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE));
        }
        return this;
    }

    private T fromDecimal(BigDecimal decimalValue, ZoneId defaultZoneId) {
        Instant instant = TimestampUtils.fromFractionalSeconds(decimalValue);
        return (T)((Temporal)this.fromInstant.apply(instant, defaultZoneId));
    }

    private T fromLong(long longValue, ZoneId defaultZoneId, DeserializationContext context) {
        if (context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
            return (T)((Temporal)this.fromInstant.apply(Instant.ofEpochSecond(longValue, 0L), defaultZoneId));
        }
        return (T)((Temporal)this.fromInstant.apply(Instant.ofEpochMilli(longValue), defaultZoneId));
    }

    private T fromTimestamp(Timestamp timestamp, ZoneId defaultZoneId) {
        Instant instant = TimestampUtils.toInstant(timestamp);
        ZoneId zoneId = this.getZoneId(timestamp, defaultZoneId);
        return (T)((Temporal)this.fromInstant.apply(instant, zoneId));
    }

    private ZoneId getZoneId(Timestamp timestamp, ZoneId defaultZoneId) {
        if (Boolean.TRUE.equals(this.adjustToContextTZOverride) || null == timestamp.getLocalOffset() || Instant.class.equals((Object)this._valueClass)) {
            return defaultZoneId;
        }
        int localOffsetMinutes = timestamp.getLocalOffset();
        return ZoneOffset.ofTotalSeconds(localOffsetMinutes * 60);
    }
}

