/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.dataformat.ion.IonGenerator;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class IonTimestampSerializers {

    public static class IonTimestampSQLDateSerializer
    extends StdScalarSerializer<java.sql.Date> {
        private static final long serialVersionUID = 1L;

        public IonTimestampSQLDateSerializer() {
            super(java.sql.Date.class);
        }

        public void serialize(java.sql.Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
                jsonGenerator.writeNumber(date.getTime());
            } else {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                cal.setTime(date);
                ((IonGenerator)jsonGenerator).writeDate(cal);
            }
        }
    }

    public static class IonTimestampJavaDateSerializer
    extends StdScalarSerializer<Date> {
        private static final long serialVersionUID = 1L;

        public IonTimestampJavaDateSerializer() {
            super(Date.class);
        }

        public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
                jsonGenerator.writeNumber(date.getTime());
            } else {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                cal.setTime(date);
                ((IonGenerator)jsonGenerator).writeDate(cal);
            }
        }
    }
}

