/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion;

import com.amazon.ion.IonSystem;
import com.amazon.ion.system.IonSystemBuilder;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.dataformat.ion.IonFactory;
import com.fasterxml.jackson.dataformat.ion.IonGenerator;
import com.fasterxml.jackson.dataformat.ion.IonParser;

public class IonFactoryBuilder
extends TSFBuilder<IonFactory, IonFactoryBuilder> {
    protected IonSystem _system;
    protected boolean _createBinaryWriters;
    protected int _formatParserFeatures;
    protected int _formatGeneratorFeatures;

    protected IonFactoryBuilder(boolean createBinary) {
        this._createBinaryWriters = createBinary;
        this._formatParserFeatures = IonFactory.DEFAULT_ION_PARSER_FEATURE_FLAGS;
        this._formatGeneratorFeatures = IonFactory.DEFAULT_ION_GENERATOR_FEATURE_FLAGS;
    }

    public IonFactoryBuilder(IonFactory base) {
        super((JsonFactory)base);
        this._createBinaryWriters = base._cfgCreateBinaryWriters;
        this._formatParserFeatures = base._ionParserFeatures;
        this._formatGeneratorFeatures = base._ionGeneratorFeatures;
    }

    public IonFactory build() {
        return new IonFactory(this);
    }

    public IonFactoryBuilder withBinaryWriters() {
        this._createBinaryWriters = true;
        return this;
    }

    public IonFactoryBuilder withTextualWriters() {
        this._createBinaryWriters = false;
        return this;
    }

    public IonFactoryBuilder ionSystem(IonSystem system) {
        this._system = system;
        return this;
    }

    public IonFactoryBuilder enable(IonParser.Feature f) {
        this._formatParserFeatures |= f.getMask();
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder enable(IonParser.Feature first, IonParser.Feature ... other) {
        this._formatParserFeatures |= first.getMask();
        for (IonParser.Feature f : other) {
            this._formatParserFeatures |= f.getMask();
        }
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder disable(IonParser.Feature f) {
        this._formatParserFeatures &= ~f.getMask();
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder disable(IonParser.Feature first, IonParser.Feature ... other) {
        this._formatParserFeatures &= ~first.getMask();
        for (IonParser.Feature f : other) {
            this._formatParserFeatures &= ~f.getMask();
        }
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder configure(IonParser.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public IonFactoryBuilder enable(IonGenerator.Feature f) {
        this._formatGeneratorFeatures |= f.getMask();
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder enable(IonGenerator.Feature first, IonGenerator.Feature ... other) {
        this._formatGeneratorFeatures |= first.getMask();
        for (IonGenerator.Feature f : other) {
            this._formatGeneratorFeatures |= f.getMask();
        }
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder disable(IonGenerator.Feature f) {
        this._formatGeneratorFeatures &= ~f.getMask();
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder disable(IonGenerator.Feature first, IonGenerator.Feature ... other) {
        this._formatGeneratorFeatures &= ~first.getMask();
        for (IonGenerator.Feature f : other) {
            this._formatGeneratorFeatures &= ~f.getMask();
        }
        return (IonFactoryBuilder)this._this();
    }

    public IonFactoryBuilder configure(IonGenerator.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public boolean willCreateBinaryWriters() {
        return this._createBinaryWriters;
    }

    public IonSystem ionSystem() {
        if (this._system == null) {
            return IonSystemBuilder.standard().build();
        }
        return this._system;
    }

    public int formatParserFeaturesMask() {
        return this._formatParserFeatures;
    }

    public int formatGeneratorFeaturesMask() {
        return this._formatGeneratorFeatures;
    }
}

