/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.common.util;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.types.ByteCount;
import org.opensearch.dataprepper.plugins.lambda.common.accumlator.Buffer;

public class ThresholdCheck {
    public static boolean checkTimeoutExceeded(Buffer currentBuffer, Duration maxCollectionDuration) {
        if (currentBuffer.getEventCount() == 0) {
            return false;
        }
        return currentBuffer.getDuration().compareTo(maxCollectionDuration) > 0;
    }

    public static boolean checkSizeThresholdExceed(Buffer currentBuffer, ByteCount maxBytes, Record<Event> nextRecord) {
        if (currentBuffer.getEventCount() == 0) {
            return false;
        }
        int estimatedRecordSize = ThresholdCheck.estimateRecordSize(nextRecord);
        return currentBuffer.getSize() + (long)estimatedRecordSize > maxBytes.getBytes();
    }

    public static boolean checkEventCountThresholdExceeded(Buffer currentBuffer, int maxEvents) {
        if (currentBuffer.getEventCount() == 0) {
            return false;
        }
        return currentBuffer.getEventCount() >= maxEvents;
    }

    private static int estimateRecordSize(Record<Event> record) {
        if (record == null || record.getData() == null) {
            return 0;
        }
        String json = ((Event)record.getData()).toJsonString();
        return json.getBytes(StandardCharsets.UTF_8).length;
    }
}

