/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.grouping;

import java.util.Collection;
import java.util.LinkedList;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.Buffer;
import org.opensearch.dataprepper.plugins.sink.s3.grouping.S3GroupIdentifier;

public class S3Group
implements Comparable<S3Group> {
    private final Buffer buffer;
    private OutputCodec outputCodec;
    private final S3GroupIdentifier s3GroupIdentifier;
    private final Collection<EventHandle> groupEventHandles;

    public S3Group(S3GroupIdentifier s3GroupIdentifier, Buffer buffer, OutputCodec outputCodec) {
        this.buffer = buffer;
        this.s3GroupIdentifier = s3GroupIdentifier;
        this.outputCodec = outputCodec;
        this.groupEventHandles = new LinkedList<EventHandle>();
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public OutputCodec getOutputCodec() {
        return this.outputCodec;
    }

    S3GroupIdentifier getS3GroupIdentifier() {
        return this.s3GroupIdentifier;
    }

    public void addEventHandle(EventHandle eventHandle) {
        this.groupEventHandles.add(eventHandle);
    }

    public void releaseEventHandles(boolean result) {
        for (EventHandle eventHandle : this.groupEventHandles) {
            eventHandle.release(result);
        }
        this.groupEventHandles.clear();
    }

    @Override
    public int compareTo(S3Group o) {
        return Long.compare(this.buffer.getSize(), o.getBuffer().getSize());
    }
}

