/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;

public class ObjectKeyOptions {
    private static final String DEFAULT_OBJECT_NAME_PATTERN = "events-%{yyyy-MM-dd'T'HH-mm-ss'Z'}";
    private static final String DEFAULT_TIME_PATTERN = "%{yyyy-MM-dd'T'HH-mm-ss'Z'}";
    @JsonProperty(value="path_prefix")
    private String pathPrefix;
    @JsonProperty(value="name_pattern_prefix")
    private String namePatternPrefix;

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public String getNamePatternPrefix() {
        return this.namePatternPrefix;
    }

    public String getNamePattern() {
        if (this.namePatternPrefix == null || this.namePatternPrefix.trim().isEmpty()) {
            return DEFAULT_OBJECT_NAME_PATTERN;
        }
        return this.namePatternPrefix + "-%{yyyy-MM-dd'T'HH-mm-ss'Z'}";
    }

    @AssertTrue(message="Custom time pattern is not allowed in the name pattern prefix since the default time pattern will be appended.")
    @AssertTrue(message="Custom time pattern is not allowed in the name pattern prefix since the default time pattern will be appended.") boolean isTimePatternExcludedFromNamePatternPrefix() {
        if (this.namePatternPrefix == null || this.namePatternPrefix.trim().isEmpty()) {
            return true;
        }
        return !this.namePatternPrefix.contains("%{");
    }
}

