/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3;

import java.time.Duration;
import org.opensearch.dataprepper.model.types.ByteCount;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.Buffer;

public class ThresholdCheck {
    private ThresholdCheck() {
    }

    public static boolean checkThresholdExceed(Buffer currentBuffer, int maxEvents, ByteCount maxBytes, Duration maxCollectionDuration) {
        if (maxEvents > 0) {
            return currentBuffer.getEventCount() + 1 > maxEvents || currentBuffer.getDuration().compareTo(maxCollectionDuration) > 0 || currentBuffer.getSize() > maxBytes.getBytes();
        }
        return currentBuffer.getDuration().compareTo(maxCollectionDuration) > 0 || currentBuffer.getSize() > maxBytes.getBytes();
    }
}

